/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.wizard;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.plugin.PluginUtilities;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.WizardSelectionPage;

public abstract class AbstractSelectionWizard
extends AbstractWizard
implements CoreStringUtil.Constants,
UiConstants.Images {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private String id;
    private IConfigurationElement elem;
    private IWizard wizard;
    private ViewerSorter sorter;

    public AbstractSelectionWizard(AbstractUIPlugin plugin, IWorkbench workbench, IStructuredSelection selection, String title, ImageDescriptor imageDescriptor, String id, ViewerSorter sorter) {
        super(plugin, title, null);
        CoreArgCheck.isNotNull((Object)workbench);
        CoreArgCheck.isNotNull((Object)selection);
        CoreArgCheck.isNotNull((Object)id);
        this.workbench = workbench;
        this.selection = selection;
        this.id = id;
        this.sorter = sorter;
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }

    @Override
    public final boolean finish() {
        return false;
    }

    public final void addPages() {
        IConfigurationElement[] elems = this.getConfigurationElementsFor();
        if (elems.length > 0) {
            this.addPage((IWizardPage)new WizardSelectionPage(elems, this.sorter));
            this.setForcePreviousAndNextButtons(true);
        }
    }

    protected IConfigurationElement[] getConfigurationElementsFor() {
        return PluginUtilities.getConfigurationElementsFor((String)this.id);
    }

    @Override
    public final boolean canFinish() {
        return false;
    }

    @Override
    public final void dispose() {
        if (this.wizard != null) {
            this.wizard.dispose();
        }
        super.dispose();
    }

    @Override
    public final IWizardPage getNextPage(IWizardPage page) {
        if (this.wizard != null) {
            this.wizard.dispose();
        }
        this.setForcePreviousAndNextButtons(false);
        return this.createWizard().getStartingPage();
    }

    protected void initializeSelectedWizard(IWizard wizard, IWorkbench workbench, IStructuredSelection selection) {
    }

    IWizard createWizard() {
        this.wizard = this.createSelectedWizard(this.elem);
        this.initializeSelectedWizard(this.wizard, this.workbench, this.selection);
        this.wizard.addPages();
        return this.wizard;
    }

    IConfigurationElement getSelectedWizard() {
        return this.elem;
    }

    void setSelectedWizard(IStructuredSelection selection) {
        this.elem = selection.isEmpty() ? null : (IConfigurationElement)selection.getFirstElement();
    }

    protected abstract IWizard createSelectedWizard(IConfigurationElement var1);

    protected abstract String getSelectedWizardIcon(IConfigurationElement var1);

    protected abstract String getSelectedWizardName(IConfigurationElement var1);
}

