/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class Label
extends CLabel {
    private static final int DFLT_GAP = 5;
    private static final int DFLT_MARGIN = 3;
    private static final int DRAW_FLAGS = 15;
    private boolean skippedSuperclassListener;
    private int gap = 5;
    private int leftMargin = 3;
    private int rightMargin = 3;
    private int topMargin = 3;
    private int bottomMargin = 3;
    private Image backgroundImage;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;

    public Label(Composite parent, int style) {
        super(parent, style);
    }

    public void addPaintListener(PaintListener listener) {
        if (this.skippedSuperclassListener) {
            super.addPaintListener(listener);
        } else {
            this.skippedSuperclassListener = !this.skippedSuperclassListener;
            super.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    Label.this.paint(event);
                }
            });
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.getTotalSize(this.getImage(), this.getText());
        size.x = wHint == -1 ? (size.x += this.leftMargin + this.rightMargin) : wHint;
        size.y = hHint == -1 ? (size.y += this.topMargin + this.bottomMargin) : hHint;
        return size;
    }

    public void dispose() {
        super.dispose();
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getGap() {
        return this.gap;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    private Point getTotalSize(Image image, String text) {
        Point size = new Point(0, 0);
        if (image != null) {
            Rectangle bounds = image.getBounds();
            size.x += bounds.width;
            size.y += bounds.height;
        }
        GC gc = new GC((Drawable)this);
        if (text != null && text.length() > 0) {
            Point extent = gc.textExtent(text, 15);
            size.x += extent.x;
            size.y = Math.max(size.y, extent.y);
            if (image != null) {
                size.x += this.gap;
            }
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }

    void paint(PaintEvent event) {
        Rectangle imgBounds;
        Color frgd;
        int align;
        int x;
        GC gc;
        String[] lines;
        Point size;
        Image img;
        Rectangle bounds;
        block34: {
            bounds = this.getClientArea();
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            boolean shortenText = false;
            String text = this.getText();
            img = this.getImage();
            int availableWidth = Math.max(0, bounds.width - this.leftMargin - this.rightMargin);
            size = this.getTotalSize(img, text);
            if (size.x > availableWidth) {
                shortenText = true;
            }
            lines = text == null ? null : this.splitString(text);
            gc = event.gc;
            if (shortenText) {
                size.x = 0;
                if (lines != null) {
                    int ndx = 0;
                    while (ndx < lines.length) {
                        Point extent = gc.textExtent(lines[ndx], 15);
                        if (extent.x > availableWidth) {
                            lines[ndx] = this.shortenText(gc, lines[ndx], availableWidth);
                            size.x = Math.max(size.x, this.getTotalSize(null, (String)lines[ndx]).x);
                        } else {
                            size.x = Math.max(size.x, extent.x);
                        }
                        ++ndx;
                    }
                    if (this.getToolTipText() == null) {
                        super.setToolTipText(text);
                    }
                }
            }
            x = bounds.x + this.leftMargin;
            align = this.getAlignment();
            if (align == 0x1000000) {
                x = (bounds.width - size.x) / 2;
            } else if (align == 131072) {
                x = bounds.width - this.rightMargin - size.x;
            }
            Color bkgd = this.getBackground();
            frgd = this.getForeground();
            try {
                if (this.backgroundImage != null) {
                    imgBounds = this.backgroundImage.getBounds();
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(bounds);
                    int imgX = 0;
                    while (imgX < bounds.width) {
                        int imgY = 0;
                        while (imgY < bounds.height) {
                            gc.drawImage(this.backgroundImage, imgX, imgY);
                            imgY += imgBounds.height;
                        }
                        imgX += imgBounds.width;
                    }
                } else if (this.gradientColors != null && this.gradientColors.length > 0) {
                    if (this.gradientColors.length == 1) {
                        if (this.gradientColors[0] != null) {
                            gc.setBackground(this.gradientColors[0]);
                        }
                        gc.fillRectangle(0, 0, bounds.width, bounds.height);
                    } else {
                        Color lastColor = this.gradientColors[0];
                        int pos = 0;
                        int ndx = 0;
                        while (ndx < this.gradientPercents.length) {
                            gc.setForeground(lastColor);
                            lastColor = this.gradientColors[ndx + 1];
                            gc.setBackground(lastColor);
                            if (this.gradientVertical) {
                                int hgt = this.gradientPercents[ndx] * bounds.height / 100 - pos;
                                gc.fillGradientRectangle(0, pos, bounds.width, hgt, true);
                                pos += hgt;
                            } else {
                                int wth = this.gradientPercents[ndx] * bounds.width / 100 - pos;
                                gc.fillGradientRectangle(pos, 0, wth, bounds.height, false);
                                pos += wth;
                            }
                            ++ndx;
                        }
                        if (this.gradientVertical && pos < bounds.height) {
                            gc.setBackground(bkgd);
                            gc.fillRectangle(0, pos, bounds.width, bounds.height - pos);
                        }
                        if (!this.gradientVertical && pos < bounds.width) {
                            gc.setBackground(bkgd);
                            gc.fillRectangle(pos, 0, bounds.width - pos, bounds.height);
                        }
                    }
                } else if ((this.getStyle() & 0x40000) != 0) {
                    gc.setBackground(bkgd);
                    gc.fillRectangle(bounds);
                }
            }
            catch (SWTException sWTException) {
                if ((this.getStyle() & 0x40000) == 0) break block34;
                gc.setBackground(bkgd);
                gc.fillRectangle(bounds);
            }
        }
        if (img != null) {
            imgBounds = img.getBounds();
            gc.drawImage(img, 0, 0, imgBounds.width, imgBounds.height, x, (bounds.height - imgBounds.height) / 2, imgBounds.width, imgBounds.height);
            x += imgBounds.width + this.gap;
            size.x -= imgBounds.width + this.gap;
        }
        if (lines != null) {
            int lineHgt = gc.getFontMetrics().getHeight();
            int textHgt = lines.length * lineHgt;
            int lineY = Math.max(this.topMargin, bounds.y + (bounds.height - textHgt) / 2);
            gc.setForeground(frgd);
            int ndx = 0;
            while (ndx < lines.length) {
                int lineX = x;
                if (lines.length > 1) {
                    int lineWth;
                    if (align == 0x1000000) {
                        lineWth = gc.textExtent((String)lines[ndx], (int)15).x;
                        lineX = x + Math.max(0, (size.x - lineWth) / 2);
                    }
                    if (align == 131072) {
                        lineWth = gc.textExtent((String)lines[ndx], (int)15).x;
                        lineX = Math.max(x, bounds.x + bounds.width - this.rightMargin - lineWth);
                    }
                }
                gc.drawText(lines[ndx], lineX, lineY, 15);
                lineY += lineHgt;
                ++ndx;
            }
        }
    }

    public void setBackground(Color color) {
        if (color != null && this.backgroundImage == null && this.gradientColors == null && this.gradientPercents == null && color.equals((Object)this.getBackground())) {
            return;
        }
        super.setBackground(color);
        this.backgroundImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.redraw();
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error((int)5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
            int ndx = 0;
            while (ndx < percents.length) {
                if (percents[ndx] < 0 || percents[ndx] > 100) {
                    SWT.error((int)5);
                }
                if (ndx > 0 && percents[ndx] < percents[ndx - 1]) {
                    SWT.error((int)5);
                }
                ++ndx;
            }
        }
        Color bkgd = this.getBackground();
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
                boolean same = false;
                int ndx = 0;
                while (ndx < this.gradientColors.length) {
                    boolean bl = same = this.gradientColors[ndx] == colors[ndx] || this.gradientColors[ndx] == null && colors[ndx] == bkgd || this.gradientColors[ndx] == bkgd && colors[ndx] == null;
                    if (!same) break;
                    ++ndx;
                }
                if (same) {
                    ndx = 0;
                    while (ndx < this.gradientPercents.length) {
                        boolean bl = same = this.gradientPercents[ndx] == percents[ndx];
                        if (!same) break;
                        ++ndx;
                    }
                }
                if (same && this.gradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colors.length];
            int ndx = 0;
            while (ndx < colors.length) {
                this.gradientColors[ndx] = colors[ndx] != null ? colors[ndx] : bkgd;
                ++ndx;
            }
            this.gradientPercents = new int[percents.length];
            ndx = 0;
            while (ndx < percents.length) {
                this.gradientPercents[ndx] = percents[ndx];
                ++ndx;
            }
            this.gradientVertical = vertical;
        }
        this.redraw();
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        this.redraw();
    }

    public void setBottomMargin(int margin) {
        this.bottomMargin = Math.max(0, margin);
    }

    public void setGap(int gap) {
        this.gap = Math.max(0, gap);
    }

    public void setHorizontalMargin(int margin) {
        this.leftMargin = this.rightMargin = Math.max(0, margin);
    }

    public void setLeftMargin(int margin) {
        this.leftMargin = Math.max(0, margin);
    }

    public void setRightMargin(int margin) {
        this.rightMargin = Math.max(0, margin);
    }

    public void setTopMargin(int margin) {
        this.topMargin = Math.max(0, margin);
    }

    public void setVerticalMargin(int margin) {
        this.topMargin = this.bottomMargin = Math.max(0, margin);
    }

    private String[] splitString(String text) {
        int pos;
        String[] lines = new String[1];
        int start = 0;
        do {
            if ((pos = text.indexOf(10, start)) == -1) {
                lines[lines.length - 1] = text.substring(start);
                continue;
            }
            boolean crlf = pos > 0 && text.charAt(pos - 1) == '\r';
            lines[lines.length - 1] = text.substring(start, pos - (crlf ? 1 : 0));
            start = pos + 1;
            String[] newLines = new String[lines.length + 1];
            System.arraycopy(lines, 0, newLines, 0, lines.length);
            lines = newLines;
        } while (pos != -1);
        return lines;
    }
}

