/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.ITreeViewerController;

public class DefaultTreeViewerController
implements InternalUiConstants.Widgets,
ITreeViewerController {
    @Override
    public void checkedStateToggled(TreeItem item) {
    }

    @Override
    public boolean isItemCheckable(TreeItem item) {
        return true;
    }

    @Override
    public void itemCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void itemDoubleClicked(DoubleClickEvent event) {
    }

    @Override
    public void itemExpanded(TreeExpansionEvent event) {
        TreeItem item;
        if (((TreeViewer)event.getTreeViewer()).getTree().getSelection().length > 0 && WidgetUtil.isChecked(item = ((TreeViewer)event.getTreeViewer()).getTree().getSelection()[0])) {
            this.updateChildren(item, true);
        }
    }

    @Override
    public void itemSelected(SelectionChangedEvent event) {
    }

    @Override
    public void update(TreeItem item, boolean selected) {
        boolean checked = !WidgetUtil.isUnchecked(item);
        item.setChecked(checked);
        item.setGrayed(WidgetUtil.isPartiallyChecked(item));
        if (selected) {
            this.updateChildren(item, checked);
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                int state = 4;
                TreeItem[] children = parent.getItems();
                int ndx = children.length;
                while (--ndx >= 0) {
                    TreeItem child = children[ndx];
                    if (WidgetUtil.isPartiallyChecked(child)) {
                        state = 4;
                        break;
                    }
                    int childState = WidgetUtil.getCheckedState(child);
                    if (state == 4) {
                        state = childState;
                        continue;
                    }
                    if (state == childState) continue;
                    state = 4;
                    break;
                }
                if (state != WidgetUtil.getCheckedState(parent)) {
                    WidgetUtil.setCheckedState(parent, state, false, this);
                }
                parent = parent.getParentItem();
            }
        }
    }

    private void updateChildren(TreeItem item, boolean checked) {
        TreeItem[] children = item.getItems();
        int ndx = children.length;
        while (--ndx >= 0) {
            TreeItem child = children[ndx];
            this.updateChildren(child, checked);
            WidgetUtil.setChecked(child, checked, false, this);
        }
    }
}

