/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.viewsupport;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class UiBusyIndicator {
    private static int nextBusyId = 1;
    private static final String BUSYID_NAME = "UI BusyIndicator";

    public static synchronized void showWhile(Display display, final Runnable runnable) {
        if (runnable == null) {
            SWT.error((int)4);
        }
        if (display == null) {
            Display display2 = display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
            if (display == null) {
                runnable.run();
                return;
            }
        }
        if (display.getThread() != Thread.currentThread()) {
            final Display d = display;
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    UiBusyIndicator.showWhileInternal(d, runnable);
                }
            });
            return;
        }
        UiBusyIndicator.showWhileInternal(display, runnable);
    }

    /*
     * Unable to fully structure code
     */
    private static void showWhileInternal(Display display, Runnable runnable) {
        if (PlatformUI.getWorkbench().isStarting()) {
            runnable.run();
            return;
        }
        busyId = new Integer(UiBusyIndicator.nextBusyId);
        ++UiBusyIndicator.nextBusyId;
        shells = display.getShells();
        i = 0;
        while (i < shells.length) {
            id = (Integer)shells[i].getData("UI BusyIndicator");
            if (id == null) {
                shells[i].setCursor(display.getSystemCursor(1));
                shells[i].setData("UI BusyIndicator", (Object)busyId);
            }
            ++i;
        }
        try {
            UiBusyIndicator.executeRunnable(display, runnable, new RunnableStatus());
        }
        finally {
            shells = display.getShells();
            i = 0;
            ** while (i < shells.length)
        }
lbl-1000:
        // 1 sources

        {
            id = (Integer)shells[i].getData("UI BusyIndicator");
            if (busyId.equals(id)) {
                shells[i].setCursor(null);
                shells[i].setData("UI BusyIndicator", null);
            }
            ++i;
            continue;
        }
lbl28:
        // 1 sources

    }

    private static void executeRunnable(final Display display, final Runnable runnable, final RunnableStatus runnableStatus) {
        String threadName = String.valueOf(UiBusyIndicator.class.getName()) + " runnable parent thread";
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            runnable.run();
                        }
                        finally {
                            runnableStatus.done();
                            display.wake();
                        }
                    }
                });
            }
        }, threadName);
        thread.setDaemon(true);
        thread.start();
        while (!runnableStatus.isDone() && !UiBusyIndicator.shellsDisposed(display)) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static boolean shellsDisposed(Display display) {
        Shell[] shells;
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (shell.isDisposed()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class RunnableStatus {
        private boolean done = false;

        private RunnableStatus() {
        }

        public void done() {
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

