/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.widget.ITreeViewerController;

public final class WidgetUtil
implements InternalUiConstants.Widgets,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(WidgetUtil.class);
    private static final String FOLDER_SELECTION_DIALOG_TITLE = WidgetUtil.getString("folderSelectionDialogTitle");
    private static final String CONFIRM_OVERWRITE_MESSAGE_ID = "confirmOverwriteMessage";
    private static final String ERROR_CAUSE_MESSAGE_ID = "errorCauseMessage";
    private static final String FILE_EXISTS_MESSAGE_ID = "fileExistsMessage";
    private static final String FILE_EXISTS_BUT_NOT_IN_WORKSPACE_MESSAGE_ID = "fileExistsButNotInWorkspaceMessage";
    private static final String INVALID_SEVERITY_MESSAGE = WidgetUtil.getString("invalidSeverityMessage");
    private static final String NOT_RADIO_BUTTON_MESSAGE = WidgetUtil.getString("notRadioButtonMessage");
    private static final String FOLDER_SELECTION_DIALOG_MESSAGE = WidgetUtil.getString("folderSelectionDialogMessage");
    private static final int COMBO_ITEM_LIMIT = 15;
    public static final String A_END_TAG = "</a>";
    public static final String A_START_TAG = "<a>";
    public static final String FORM_TEXT_END_TAG = "</p></html>";
    public static final String FORM_TEXT_START_TAG = "<html><p>";
    public static final int TEXT_COLOR_DEFAULT = 0;
    public static final int TEXT_COLOR_BLUE = 1;
    private static final String EMPTY_STR = "";

    public static boolean confirmOverwrite(File file) {
        return WidgetUtil.showConfirmation(WidgetUtil.getString(CONFIRM_OVERWRITE_MESSAGE_ID, WidgetUtil.getFileExistsMessage(file)));
    }

    public static Map disable(Control[] controls) {
        CoreArgCheck.isNotNull((Object)controls);
        HashMap map = new HashMap(0);
        int ndx = controls.length;
        while (--ndx >= 0) {
            Control ctrl = controls[ndx];
            CoreArgCheck.isNotNull((Object)ctrl);
            WidgetUtil.disable(ctrl, map);
        }
        return map;
    }

    private static void disable(Control control, Map map) {
        if (!map.containsKey(control)) {
            map.put(control, new Boolean(control.getEnabled()));
        }
        control.setEnabled(false);
        if (control instanceof Composite) {
            Control[] ctrls = ((Composite)control).getChildren();
            int ndx = ctrls.length;
            while (--ndx >= 0) {
                WidgetUtil.disable(ctrls[ndx], map);
            }
        }
    }

    public static void disableFormText(FormText formText) {
        HyperlinkSettings settings = formText.getHyperlinkSettings();
        settings.setHyperlinkUnderlineMode(1);
        settings.setForeground(formText.getForeground());
        settings.setActiveForeground(formText.getForeground());
        formText.redraw();
    }

    public static Map disable(Composite container) {
        CoreArgCheck.isNotNull((Object)container);
        return WidgetUtil.disable(new Control[]{container});
    }

    public static void enable(Control[] controls) {
        CoreArgCheck.isNotNull((Object)controls);
        int ndx = controls.length;
        while (--ndx >= 0) {
            Control ctrl = controls[ndx];
            CoreArgCheck.isNotNull((Object)ctrl);
            if (ctrl instanceof Composite) {
                WidgetUtil.enable(((Composite)ctrl).getChildren());
            }
            ctrl.setEnabled(true);
        }
    }

    public static void enable(Composite container) {
        WidgetUtil.enable(new Control[]{container});
    }

    public static void enableFormText(FormText formText) {
        HyperlinkSettings settings = formText.getHyperlinkSettings();
        settings.setHyperlinkUnderlineMode(3);
        settings.setForeground(JFaceColors.getHyperlinkText((Display)formText.getDisplay()));
        settings.setActiveForeground(JFaceColors.getActiveHyperlinkText((Display)formText.getDisplay()));
        formText.redraw();
    }

    public static TreeItem findTreeItem(Object node, Tree tree) {
        CoreArgCheck.isNotNull((Object)node);
        CoreArgCheck.isNotNull((Object)tree);
        return WidgetUtil.findTreeItem(node, tree.getItems());
    }

    public static TreeItem findTreeItem(Object node, TreeViewer viewer) {
        CoreArgCheck.isNotNull((Object)viewer);
        return WidgetUtil.findTreeItem(node, viewer.getTree());
    }

    private static TreeItem findTreeItem(Object node, TreeItem[] items) {
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            if (node == item.getData()) {
                return item;
            }
            if (item.getItemCount() <= 0 || (item = WidgetUtil.findTreeItem(node, item.getItems())) == null) continue;
            return item;
        }
        return null;
    }

    public static String getCauseMessage(String prefix, IStatus status) {
        return WidgetUtil.getString(ERROR_CAUSE_MESSAGE_ID, prefix, status.getMessage());
    }

    public static String getCauseMessage(String prefix, Throwable throwable) {
        return WidgetUtil.getString(ERROR_CAUSE_MESSAGE_ID, prefix, throwable.getLocalizedMessage());
    }

    public static int getCheckedState(TreeItem item) {
        CoreArgCheck.isNotNull((Object)item);
        Object obj = item.getData("checkedState");
        if (obj == null || !(obj instanceof Integer)) {
            return 1;
        }
        return (Integer)obj;
    }

    public static Map getCheckedStates(TreeViewer tvViewer) {
        HashMap hmItemCheckedStates = new HashMap();
        TreeItem[] tiItems = tvViewer.getTree().getItems();
        int i = 0;
        while (i < tiItems.length) {
            TreeItem tiTemp = tiItems[i];
            WidgetUtil.getCheckedStates(hmItemCheckedStates, tiTemp);
            ++i;
        }
        return hmItemCheckedStates;
    }

    private static void getCheckedStates(Map mapItemCheckedStates, TreeItem tiItem) {
        mapItemCheckedStates.put(tiItem.getData(), new Boolean(tiItem.getChecked()));
        TreeItem[] tiChildren = tiItem.getItems();
        int i = 0;
        while (i < tiChildren.length) {
            WidgetUtil.getCheckedStates(mapItemCheckedStates, tiChildren[i]);
            ++i;
        }
    }

    public static String getFileExistsMessage(File file) {
        return WidgetUtil.getString(FILE_EXISTS_MESSAGE_ID, file.getAbsolutePath());
    }

    public static String getFileExistsMessage(IFile file) {
        return WidgetUtil.getString(FILE_EXISTS_MESSAGE_ID, file.getFullPath().makeRelative());
    }

    public static String getFileExistsButNotInWorkspaceMessage(IFile file) {
        return WidgetUtil.getString(FILE_EXISTS_BUT_NOT_IN_WORKSPACE_MESSAGE_ID, file.getFullPath().makeRelative());
    }

    public static String getMessage(Throwable error) {
        String msg;
        Throwable err;
        CoreArgCheck.isNotNull((Object)error);
        if (error instanceof WrappedException) {
            err = ((WrappedException)error).exception();
            if (err != null) {
                error = err;
            }
        } else if (error instanceof InvocationTargetException && (err = ((InvocationTargetException)error).getTargetException()) != null) {
            error = err;
        }
        return (msg = error.getLocalizedMessage()) == null ? error.toString() : msg;
    }

    public static boolean hasState(int state, int queriedState) {
        return (state & queriedState) == queriedState;
    }

    public static boolean hasStyle(Widget widget, int style) {
        CoreArgCheck.isNotNull((Object)widget);
        return WidgetUtil.hasState(widget.getStyle(), style);
    }

    public static Color getDarkBlueColor() {
        return WidgetUtil.getSystemColor(10);
    }

    public static Color getReadOnlyBackgroundColor() {
        return WidgetUtil.getSystemColor(19);
    }

    public static Color getSystemColor(int colorId) {
        return Display.getCurrent().getSystemColor(colorId);
    }

    public static void colorizeWidget(Control control, int colorStyle, boolean readOnly) {
        if (colorStyle == 1) {
            control.setForeground(Display.getCurrent().getSystemColor(10));
        }
        if (readOnly) {
            control.setBackground(Display.getCurrent().getSystemColor(19));
        }
    }

    public static void initializePanel(Composite panel, int gridStyle, int span, int columns) {
        GridData gridData = new GridData(gridStyle);
        gridData.horizontalSpan = span;
        panel.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(columns, false);
        if (WidgetUtil.hasStyle((Widget)panel, 8)) {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        panel.setLayout((Layout)layout);
    }

    public static IDialogSettings initializeSettings(Object object, AbstractUIPlugin plugin) {
        String name;
        IDialogSettings settings = plugin.getDialogSettings();
        IDialogSettings section = settings.getSection(name = object.getClass().getName());
        if (section == null) {
            section = settings.addNewSection(name);
        }
        return section;
    }

    public static boolean isChecked(TreeItem item) {
        return WidgetUtil.hasState(WidgetUtil.getCheckedState(item), 2);
    }

    public static boolean isPartiallyChecked(TreeItem item) {
        return WidgetUtil.hasState(WidgetUtil.getCheckedState(item), 4);
    }

    public static boolean isUnchecked(TreeItem item) {
        return WidgetUtil.hasState(WidgetUtil.getCheckedState(item), 1);
    }

    public static void pack(TableViewer viewer) {
        WidgetUtil.pack(viewer.getTable());
    }

    public static void pack(Table table) {
        TableColumn[] cols = table.getColumns();
        int ndx = 0;
        while (ndx < cols.length) {
            cols[ndx].pack();
            ++ndx;
        }
    }

    public static void removeMissingResources(IDialogSettings settings, String id) {
        CoreArgCheck.isNotNull((Object)settings);
        CoreArgCheck.isNotNull((Object)id);
        String[] resourceItems = settings.getArray(id);
        if (resourceItems != null && resourceItems.length > 0) {
            ArrayList<String> newItems = new ArrayList<String>(Arrays.asList(resourceItems));
            File tmp = null;
            Iterator itr = newItems.iterator();
            while (itr.hasNext()) {
                String sItem = (String)itr.next();
                if (sItem == null) {
                    itr.remove();
                    continue;
                }
                tmp = new File(sItem);
                if (tmp.exists()) continue;
                itr.remove();
            }
            if (resourceItems.length != newItems.size()) {
                String[] resourceNames = new String[newItems.size()];
                int ndx = resourceNames.length;
                while (--ndx >= 0) {
                    resourceNames[ndx] = (String)newItems.get(ndx);
                }
                settings.put(id, resourceNames);
            }
        }
    }

    public static void restore(Map map) {
        CoreArgCheck.isNotNull((Object)map);
        for (Map.Entry entry : map.entrySet()) {
            ((Control)entry.getKey()).setEnabled(((Boolean)entry.getValue()).booleanValue());
        }
    }

    public static void saveSettings(IDialogSettings settings, String id, Combo combo) {
        WidgetUtil.saveSettings(settings, id, combo, 15);
    }

    public static void saveSettings(IDialogSettings theSettings, String theId, Combo theCombo, int theLimit) {
        CoreArgCheck.isNotNull((Object)theSettings);
        CoreArgCheck.isNotNull((Object)theId);
        CoreArgCheck.isNotNull((Object)theCombo);
        CoreArgCheck.isPositive((int)theLimit);
        String currentValue = theCombo.getText();
        if (currentValue.length() > 0 && theCombo.indexOf(currentValue) == -1) {
            theCombo.add(currentValue);
        }
        if (theCombo.getItemCount() > theLimit) {
            theCombo.remove(0, theCombo.getItemCount() - theLimit - 1);
        }
        theSettings.put(theId, theCombo.getItems());
    }

    public static void select(Object object, Viewer viewer) {
        IStructuredSelection selection;
        if (object != null && ((selection = (IStructuredSelection)viewer.getSelection()).size() != 1 || selection.getFirstElement() != object)) {
            viewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }

    public static void selectRadioButton(Button button) {
        CoreArgCheck.isNotNull((Object)button);
        CoreArgCheck.isTrue((boolean)WidgetUtil.hasStyle((Widget)button, 16), (String)NOT_RADIO_BUTTON_MESSAGE);
        Composite parent = button.getParent();
        Control[] kids = parent.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (kids[i] != button && kids[i] instanceof Button && WidgetUtil.hasStyle((Widget)kids[i], 16) && ((Button)kids[i]).getSelection()) {
                Button oldButton = (Button)kids[i];
                oldButton.setSelection(false);
                oldButton.notifyListeners(13, new Event());
                break;
            }
            ++i;
        }
        if (!button.getSelection()) {
            button.setSelection(true);
            button.notifyListeners(13, new Event());
        }
    }

    public static void setChecked(TreeItem item, boolean checked, boolean selected, ITreeViewerController controller) {
        WidgetUtil.setCheckedState(item, checked ? 2 : 1, selected, controller);
    }

    public static void setCheckedState(TreeItem item, int state, boolean selected, ITreeViewerController controller) {
        CoreArgCheck.isNotNull((Object)item);
        CoreArgCheck.isNotNull((Object)controller);
        item.setData("checkedState", (Object)new Integer(state));
        controller.update(item, selected);
    }

    public static void setCheckedStates(TreeViewer tvViewer, Map mapItemCheckedStates) {
        TreeItem[] tiItems = tvViewer.getTree().getItems();
        int i = 0;
        while (i < tiItems.length) {
            TreeItem tiTemp = tiItems[i];
            WidgetUtil.setCheckedStates(mapItemCheckedStates, tiTemp);
            ++i;
        }
    }

    private static void setCheckedStates(Map mapItemCheckedStates, TreeItem tiItem) {
        Boolean BChecked = (Boolean)mapItemCheckedStates.get(tiItem.getData());
        tiItem.setChecked(BChecked.booleanValue());
        TreeItem[] tiChildren = tiItem.getItems();
        int i = 0;
        while (i < tiChildren.length) {
            WidgetUtil.setCheckedStates(mapItemCheckedStates, tiChildren[i]);
            ++i;
        }
    }

    public static void setComboItems(Combo combo, List items) {
        WidgetUtil.setComboItems(combo, items, null);
    }

    public static void setComboItems(Combo combo, List items, ILabelProvider provider) {
        WidgetUtil.setComboItems(combo, items, provider, false);
    }

    public static void setComboItems(Combo combo, Collection items, ILabelProvider provider, boolean sort) {
        CoreArgCheck.isNotNull((Object)combo);
        WidgetUtil.setComboItems(combo, items, provider, sort, combo.getText());
    }

    public static void setComboItems(Combo combo, Collection items, ILabelProvider provider, boolean sort, String selection) {
        CoreArgCheck.isNotNull((Object)combo);
        CoreArgCheck.isNotNull((Object)items);
        combo.removeAll();
        ArrayList<String> itemStrings = new ArrayList<String>(items.size());
        for (Object item : items) {
            String text = provider == null ? item.toString() : provider.getText(item);
            itemStrings.add(text);
        }
        ArrayList<String> sortedItems = new ArrayList<String>();
        sortedItems.addAll(itemStrings);
        Collections.sort(sortedItems);
        combo.setItems(sortedItems.toArray(new String[0]));
        if (selection != null && selection.length() > 0) {
            combo.setText(selection);
        }
    }

    public static void setComboText(Combo combo, Object selection) {
        WidgetUtil.setComboText(combo, selection, null);
    }

    public static void setComboText(Combo combo, Object selection, ILabelProvider provider) {
        WidgetUtil.setComboText(combo, selection, provider, false);
    }

    public static void setComboText(Combo combo, Object selection, ILabelProvider provider, boolean add) {
        ArrayList<String> items;
        String text;
        CoreArgCheck.isNotNull((Object)combo);
        String string = selection == null ? EMPTY_STR : (text = provider == null ? selection.toString() : provider.getText(selection));
        if (add && !(items = new ArrayList<String>(Arrays.asList(combo.getItems()))).contains(text)) {
            items.add(text);
            WidgetUtil.setComboItems(combo, items, provider);
        }
        combo.setText(text);
    }

    public static void setText(Text text, String textValue) {
        if (text == null) {
            return;
        }
        if (textValue == null) {
            textValue = EMPTY_STR;
        }
        text.setText(textValue);
    }

    public static void setLayoutData(Button button) {
        GridData gd = new GridData(256);
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)gd);
        gc.dispose();
    }

    public static int[] getSashFormWeights(SashForm theSash) {
        CoreArgCheck.isNotNull((Object)theSash);
        Control[] kids = theSash.getChildren();
        boolean vertical = WidgetUtil.hasStyle((Widget)theSash, 512);
        int[] weights = null;
        double total = 0.0;
        if (kids.length > 0) {
            ArrayList<Integer> temp = new ArrayList<Integer>();
            int i = 0;
            while (i < kids.length) {
                if (!(kids[i] instanceof Sash)) {
                    Point point = kids[i].computeSize(-1, -1);
                    int size = vertical ? point.y : point.x;
                    temp.add(new Integer(size));
                    total += (double)size;
                }
                ++i;
            }
            weights = new int[temp.size()];
            i = 0;
            while (i < weights.length) {
                int size = (Integer)temp.get(i);
                weights[i] = (int)Math.round((double)size / total * 100.0);
                ++i;
            }
        }
        return weights;
    }

    public static Image getStatusImage(IStatus status) {
        if (status.getSeverity() == 4) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (status.getSeverity() == 2) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (status.getSeverity() == 1) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        return null;
    }

    public static void show(IStatus status) {
        CoreArgCheck.isNotNull((Object)status);
        switch (status.getSeverity()) {
            case 4: {
                WidgetUtil.showError(status.getMessage());
                break;
            }
            case 2: {
                WidgetUtil.showWarning(status.getMessage());
                break;
            }
            default: {
                WidgetUtil.showNotification(status.getMessage());
            }
        }
    }

    public static void showCause(String prefix, Throwable throwable) {
        WidgetUtil.showCause(prefix, throwable, 4);
    }

    public static void showCause(String prefix, Throwable throwable, int severity) {
        CoreArgCheck.isNotNull((Object)prefix);
        CoreArgCheck.isNotNull((Object)throwable);
        CoreArgCheck.isTrue((severity == 4 || severity == 2 ? 1 : 0) != 0, (String)INVALID_SEVERITY_MESSAGE);
        WidgetUtil.show((IStatus)new Status(severity, "org.teiid.designer.ui.common", 0, WidgetUtil.getCauseMessage(prefix, throwable), throwable));
    }

    public static boolean showConfirmation(String message) {
        CoreArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        return MessageDialog.openConfirm((Shell)shell, (String)CONFIRM_MESSAGE_TITLE, (String)message);
    }

    public static void showError(String message) {
        CoreArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        MessageDialog.openError((Shell)shell, (String)ERROR_MESSAGE_TITLE, (String)message);
    }

    public static void showError(Throwable error) {
        WidgetUtil.showError(WidgetUtil.getMessage(error));
    }

    public static IContainer showFolderSelectionDialog(IContainer selection, final ViewerFilter filter, ISelectionStatusValidator validator) {
        ViewerFilter baseFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return element instanceof IContainer && ((IContainer)element).isAccessible() && (filter == null || filter.select(viewer, parent, element));
            }
        };
        Object[] objs = WidgetUtil.showWorkspaceObjectSelectionDialog(FOLDER_SELECTION_DIALOG_TITLE, FOLDER_SELECTION_DIALOG_MESSAGE, false, selection, baseFilter, validator);
        return objs.length == 0 ? null : (IContainer)objs[0];
    }

    public static void showNotification(String message) {
        CoreArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        MessageDialog.openInformation((Shell)shell, (String)NOTIFICATION_MESSAGE_TITLE, (String)message);
    }

    public static void showWarning(String message) {
        CoreArgCheck.isNotNull((Object)message);
        Shell shell = Display.getCurrent().getActiveShell();
        MessageDialog.openWarning((Shell)shell, (String)WARNING_MESSAGE_TITLE, (String)message);
    }

    public static Object[] showWorkspaceObjectSelectionDialog(String title, String message, boolean allowMultiple, Object selection, ViewerFilter filter, ISelectionStatusValidator validator) {
        return WidgetUtil.showWorkspaceObjectSelectionDialog(title, message, allowMultiple, selection, filter, validator, (ILabelProvider)new WorkbenchLabelProvider());
    }

    public static Object[] showWorkspaceObjectSelectionDialog(String title, String message, boolean allowMultiple, Object selection, ViewerFilter filter, ISelectionStatusValidator validator, ILabelProvider labelProvider) {
        Shell shell = Display.getCurrent().getActiveShell();
        ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(shell, labelProvider, (ITreeContentProvider)new WorkbenchContentProvider()){};
        dlg.setAllowMultiple(allowMultiple);
        dlg.setTitle(title);
        dlg.setMessage(message);
        if (filter != null) {
            dlg.addFilter(filter);
        }
        if (validator != null) {
            dlg.setValidator(validator);
        }
        dlg.setInput((Object)ModelerCore.getWorkspace().getRoot());
        if (selection != null) {
            dlg.setInitialSelection(selection);
        }
        if (dlg.open() == 0) {
            return dlg.getResult();
        }
        return EMPTY_STRING_ARRAY;
    }

    public static Object[] showWorkspaceObjectSelectionDialog(String title, String message, boolean allowMultiple, Object selection, ViewerFilter filter, ISelectionStatusValidator validator, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        Shell shell = Display.getCurrent().getActiveShell();
        ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(shell, labelProvider, contentProvider){};
        dlg.setAllowMultiple(allowMultiple);
        dlg.setTitle(title);
        dlg.setMessage(message);
        if (filter != null) {
            dlg.addFilter(filter);
        }
        if (validator != null) {
            dlg.setValidator(validator);
        }
        dlg.setInput((Object)ModelerCore.getWorkspace().getRoot());
        if (selection != null) {
            dlg.setInitialSelection(selection);
        }
        if (dlg.open() == 0) {
            return dlg.getResult();
        }
        return EMPTY_STRING_ARRAY;
    }

    public static boolean widgetValueChanged(Text widget, String targetValue) {
        CoreArgCheck.isNotNull((Object)widget);
        return !StringUtilities.equals((String)widget.getText(), (String)targetValue);
    }

    public static boolean widgetValueChanged(Text widget, int targetValue) {
        CoreArgCheck.isNotNull((Object)widget);
        if (widget.getText() == null || widget.getText().length() == 0) {
            return true;
        }
        int widgetValue = Integer.valueOf(widget.getText());
        return widgetValue != targetValue;
    }

    public static boolean widgetValueChanged(Combo widget, String targetValue) {
        CoreArgCheck.isNotNull((Object)widget);
        return !StringUtilities.equals((String)widget.getText(), (String)targetValue);
    }

    public static boolean widgetValueChanged(Button widget, boolean selected) {
        CoreArgCheck.isNotNull((Object)widget);
        return widget.getSelection() ^ selected;
    }

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object parameter) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, parameter);
    }

    private static String getString(String id, Object parameter1, Object parameter2) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{parameter1, parameter2});
    }

    private WidgetUtil() {
    }
}

