/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;

public class SystemClipboardUtilities {
    public static final String COLUMN_DELIMITER = "\t";
    public static final String ROW_DELIMITER = "\n";

    private SystemClipboardUtilities() {
    }

    public static void clear() {
        SystemClipboardUtilities.clear((Transfer)TextTransfer.getInstance());
    }

    public static void clear(Transfer theTransferType) {
        Clipboard cb = SystemClipboardUtilities.getSystemClipboard();
        cb.setContents(new Object[1], new Transfer[]{theTransferType});
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<List<String>> convertTableData(String theTableData) {
        CoreArgCheck.isNotNull((Object)theTableData);
        ArrayList<List<String>> arylResult = new ArrayList<List<String>>();
        boolean firstToken = true;
        StringTokenizer stOuter = new StringTokenizer(theTableData, "\r\n", true);
        boolean prevTokenWasDelimiter = false;
        while (stOuter.hasMoreTokens()) {
            String token;
            block7: {
                block8: {
                    token = stOuter.nextToken();
                    if (token.equals("\r")) {
                        token = stOuter.nextToken();
                    }
                    if (!token.equals(ROW_DELIMITER)) break block8;
                    if (firstToken) {
                        token = "";
                        prevTokenWasDelimiter = true;
                        break block7;
                    } else if (prevTokenWasDelimiter) {
                        token = "";
                        break block7;
                    } else {
                        prevTokenWasDelimiter = true;
                        continue;
                    }
                }
                prevTokenWasDelimiter = false;
            }
            if (firstToken) {
                firstToken = false;
            }
            List<String> lstLineArry = SystemClipboardUtilities.convertColumnData(token);
            arylResult.add(lstLineArry);
        }
        return arylResult;
    }

    public static List<String> convertColumnData(String theRowData) {
        CoreArgCheck.isNotNull((Object)theRowData);
        String sThisToken = "";
        String sLastToken = "";
        ArrayList<String> arylResult = new ArrayList<String>();
        StringTokenizer stInner = new StringTokenizer(theRowData, COLUMN_DELIMITER, true);
        if (stInner.hasMoreTokens()) {
            boolean firstToken = true;
            while (stInner.hasMoreTokens()) {
                sThisToken = stInner.nextToken();
                if (sThisToken.equals(COLUMN_DELIMITER)) {
                    if (firstToken) {
                        arylResult.add("");
                    } else if (sLastToken.equals(COLUMN_DELIMITER)) {
                        arylResult.add("");
                    }
                } else {
                    arylResult.add(sThisToken);
                }
                sLastToken = sThisToken;
                if (!firstToken) continue;
                firstToken = false;
            }
            if (sLastToken.equals(COLUMN_DELIMITER)) {
                arylResult.add("");
            }
        } else {
            arylResult.add(theRowData);
        }
        return arylResult;
    }

    public static Clipboard getSystemClipboard() {
        return new Clipboard(Display.getCurrent());
    }

    public static String getContents() {
        return (String)SystemClipboardUtilities.getContents((Transfer)TextTransfer.getInstance());
    }

    public static void copyToClipboard(ISelection theSelection) {
        List<Object> objects = SelectionUtilities.getSelectedObjects(theSelection);
        if (!objects.isEmpty()) {
            StringBuffer text = new StringBuffer();
            int size = objects.size();
            int i = 0;
            while (i < size) {
                text.append(objects.get(i));
                if (i < size - 1) {
                    text.append('\n');
                }
                ++i;
            }
            SystemClipboardUtilities.setContents(text.toString());
        }
    }

    public static Object getContents(Transfer theTransferType) {
        CoreArgCheck.isNotNull((Object)theTransferType);
        return SystemClipboardUtilities.getSystemClipboard().getContents(theTransferType);
    }

    public static boolean isEmpty() {
        return SystemClipboardUtilities.isEmpty((Transfer)TextTransfer.getInstance());
    }

    public static boolean isEmpty(Transfer theTransferType) {
        return SystemClipboardUtilities.getContents(theTransferType) == null;
    }

    public static void setContents(String theContents) {
        SystemClipboardUtilities.setContents(theContents, (Transfer)TextTransfer.getInstance());
    }

    public static void setContents(Object theContent, Transfer theTransferType) {
        CoreArgCheck.isNotNull((Object)theTransferType);
        Clipboard cb = SystemClipboardUtilities.getSystemClipboard();
        cb.setContents(new Object[]{theContent}, new Transfer[]{theTransferType});
    }
}

