/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.text;

import org.eclipse.swt.graphics.Font;

public class ScaledFontManager {
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final int MIN_FONT_SIZE = 4;
    private static final int MAX_FONT_SIZE = 40;
    private static int currentSize = 10;
    private static String currentName = "Veranda";
    private static int currentStyle = 0;
    private Font currentFont;

    public Font getCurrentFont() {
        if (this.currentFont == null) {
            this.currentFont = new Font(null, currentName, 10, currentStyle);
        }
        return this.currentFont;
    }

    public Font createFontOfSize(int iSize) {
        boolean createFont = true;
        if (this.currentFont != null) {
            if (this.currentFont.getFontData()[0].getHeight() == iSize) {
                createFont = false;
            } else {
                this.currentFont.dispose();
            }
        }
        if (createFont) {
            this.currentFont = new Font(null, currentName, iSize, currentStyle);
        }
        return this.currentFont;
    }

    public void increase() {
        int currSize = this.getSize();
        if (currSize < 40) {
            this.setSize(currSize + 1);
        }
    }

    public void decrease() {
        int currSize = this.getSize();
        if (currSize > 4) {
            this.setSize(currSize - 1);
        }
    }

    public boolean canIncrease() {
        int currSize = this.getSize();
        return currSize < 40;
    }

    public boolean canDecrease() {
        int currSize = this.getSize();
        return currSize > 4;
    }

    public Font getFont() {
        return this.currentFont;
    }

    public String getName() {
        return currentName;
    }

    public int getSize() {
        return currentSize;
    }

    public int getStyle() {
        return currentStyle;
    }

    public void setFont(Font newFont) {
        this.currentFont = newFont;
    }

    public void setName(String newName) {
        currentName = newName;
    }

    public void setStyle(int newStyle) {
        currentStyle = newStyle;
        this.resetFont();
    }

    public void setSize(int newSize) {
        currentSize = newSize;
        this.resetFont();
    }

    public void resetFont() {
        this.setFont(new Font(null, this.getName(), this.getSize(), this.getStyle()));
    }
}

