/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.eventsupport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProvider
implements ISelectionProvider {
    private ArrayList<ISelectionChangedListener> listenerList = new ArrayList();
    private ISelection currentSelection;

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public synchronized void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.remove(listener);
    }

    public void setSelection(SelectionChangedEvent event) {
        if (event == null) {
            this.currentSelection = null;
        } else {
            this.currentSelection = event.getSelection();
            this.fireSelectionChangedEvent(event);
        }
    }

    public void setSelection(List selectedObjects) {
        if (selectedObjects != null) {
            this.setSelection((ISelection)new StructuredSelection(selectedObjects), true, null);
        }
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, true, null);
    }

    public void setSelection(ISelection selection, boolean fireEvent) {
        this.setSelection(selection, fireEvent, null);
    }

    public void setSelection(ISelection selection, boolean fireEvent, ISelectionProvider source) {
        this.currentSelection = selection;
        if (fireEvent) {
            if (source == null) {
                source = this;
            }
            this.fireSelectionChangedEvent(new SelectionChangedEvent(source, selection));
        }
    }

    public synchronized void fireSelectionChangedEvent(SelectionChangedEvent event) {
        ArrayList<ISelectionChangedListener> copyOfListenerList = new ArrayList<ISelectionChangedListener>(this.listenerList);
        Iterator iter = copyOfListenerList.iterator();
        while (iter.hasNext()) {
            ((ISelectionChangedListener)iter.next()).selectionChanged(event);
        }
    }

    public List<ISelectionChangedListener> getListenerList() {
        return this.listenerList;
    }
}

