/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.IActionConstants;

public class GlobalActionsMap
implements Map,
IActionConstants,
UiConstants {
    public static final IAction UNSUPPORTED_ACTION;
    public static final Object DEFAULT_ACTION;
    private Map map = new HashMap();

    static {
        DEFAULT_ACTION = null;
        UNSUPPORTED_ACTION = new AbstractAction(UiPlugin.getDefault()){

            @Override
            protected void doRun() {
            }

            public void setEnabled(boolean theEnabled) {
                super.setEnabled(false);
            }
        };
        UNSUPPORTED_ACTION.setEnabled(false);
    }

    public GlobalActionsMap() {
        this.reset();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(Util.getString("GlobalActionsMap.unsupportedOperation", new Object[0]));
    }

    @Override
    public boolean containsKey(Object theKey) {
        return this.map.containsKey(theKey);
    }

    @Override
    public boolean containsValue(Object theValue) {
        return this.map.containsValue(theValue);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object theKey) {
        return this.map.get(theKey);
    }

    public IAction getAction(String theKey) {
        return (IAction)this.get(theKey);
    }

    public boolean isDefaultAction(String theKey) {
        return this.isValidKey(theKey) && this.get(theKey) == DEFAULT_ACTION;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public static boolean isEclipseGlobalAction(String theKey) {
        return Arrays.asList(IActionConstants.EclipseGlobalActions.ALL_ACTIONS).contains(theKey);
    }

    public boolean isUnsupportedAction(Object theKey) {
        return this.get(theKey) == UNSUPPORTED_ACTION;
    }

    public boolean isValidKey(Object theKey) {
        boolean result = false;
        if (theKey != null) {
            int i = 0;
            while (i < IActionConstants.EclipseGlobalActions.ALL_ACTIONS.length) {
                if (theKey.equals(IActionConstants.EclipseGlobalActions.ALL_ACTIONS[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object theKey, Object theValue) {
        if (theKey == null) {
            throw new NullPointerException(Util.getString("GlobalActionsMap.nullKey", new Object[0]));
        }
        if (!this.isValidKey(theKey)) {
            throw new IllegalArgumentException(Util.getString("GlobalActionsMap.invalidKey", new Object[]{theKey}));
        }
        return this.map.put(theKey, theValue);
    }

    public void putAll(Map theMap) {
        if (theMap != null) {
            for (Map.Entry entry : theMap.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object remove(Object theKey) {
        throw new UnsupportedOperationException(Util.getString("GlobalActionsMap.unsupportedOperation", new Object[0]));
    }

    public void reset() {
        this.map.clear();
        int i = 0;
        while (i < IActionConstants.EclipseGlobalActions.ALL_ACTIONS.length) {
            this.put(IActionConstants.EclipseGlobalActions.ALL_ACTIONS[i], DEFAULT_ACTION);
            ++i;
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public Collection values() {
        return this.map.values();
    }
}

