/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.ui.structure;

import java.io.InputStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.DifferenceProcessor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.ModelerComparePlugin;
import org.teiid.designer.compare.ui.UiConstants;
import org.teiid.designer.compare.ui.tree.DifferenceReportsPanel;
import org.teiid.designer.compare.ui.tree.MappingTreeContentProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelFolderImpl;
import org.teiid.designer.core.workspace.ModelFolderInfo;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelProjectInfo;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceItemImpl;

public class ModelObjectStructureViewer
extends StructuredViewer {
    private Composite cmpParent;
    private DifferenceProcessor dpProcessor;
    private DifferenceReport drReport;
    private DifferenceReportsPanel pnlDifferenceReport;
    private HistoryItem hiRight;
    private ResourceNode rnLeft;
    private ResourceNode rnRight;
    private int iCompareType = -1;
    private static final int RESOURCE_NODE_TO_INPUT_STREAM = 1;
    private static final int RESOURCE_NODE_TO_RESOURCE_NODE = 2;
    private static final String EMPTY_STRING = "";
    private int iTerminology = 1;
    private static final String DIALOG_TITLE = UiConstants.Util.getString("ModelObjectStructureViewer.dialogTitle", new Object[0]);
    private static final String TREE_TITLE = UiConstants.Util.getString("ModelObjectStructureViewer.treeTitle", new Object[0]);
    private static final String DIFF_DESCRIPTOR_TITLE = UiConstants.Util.getString("ModelObjectStructureViewer.diffDescriptorTitle", new Object[0]);

    public ModelObjectStructureViewer(Composite parent, CompareConfiguration configuration) {
        this.cmpParent = parent;
        this.setContentProvider((IContentProvider)new MappingTreeContentProvider());
        this.getContentProvider();
    }

    protected void inputChanged(Object input, Object oldInput) {
        ITypedElement teRight;
        if (input == null) {
            return;
        }
        InputStream isRight = null;
        Path pathRight = null;
        IResource resLeft = null;
        IResource resRight = null;
        DiffNode node = (DiffNode)input;
        ITypedElement teLeft = node.getLeft();
        if (teLeft instanceof ResourceNode) {
            this.rnLeft = (ResourceNode)teLeft;
            resLeft = this.rnLeft.getResource();
        }
        if ((teRight = node.getRight()) instanceof ResourceNode) {
            this.iCompareType = 2;
            this.rnRight = (ResourceNode)teRight;
            resRight = this.rnRight.getResource();
        } else if (teRight instanceof HistoryItem) {
            this.iCompareType = 1;
            this.rnRight = null;
            this.hiRight = (HistoryItem)teRight;
            pathRight = new Path(this.hiRight.getName());
            try {
                isRight = this.hiRight.getContents();
            }
            catch (CoreException ce) {
                UiConstants.Util.log((Throwable)ce);
            }
        }
        if (this.iCompareType == 2) {
            try {
                ModelResource mrLeft = this.findModelResource(resLeft, true);
                ModelResource mrRight = this.findModelResource(resRight, true);
                this.dpProcessor = ModelerComparePlugin.createDifferenceProcessor((ModelResource)mrLeft, (ModelResource)mrRight);
            }
            catch (ModelWorkspaceException mwe) {
                UiConstants.Util.log((Throwable)mwe);
            }
        } else {
            IProject project = null;
            if (resLeft != null) {
                project = resLeft.getProject();
            }
            if (project != null && project.isOpen() && ModelerCore.hasModelNature((IProject)project) && resLeft.getType() == 1) {
                try {
                    ModelResource mrLeft = this.findModelResource(resLeft, true);
                    if (mrLeft != null) {
                        this.dpProcessor = ModelerComparePlugin.createDifferenceProcessor((InputStream)isRight, (IPath)pathRight, (ModelResource)mrLeft, (String)mrLeft.getDescription());
                    }
                }
                catch (ModelWorkspaceException mwe) {
                    UiConstants.Util.log((Throwable)mwe);
                }
            }
        }
        this.dpProcessor.execute((IProgressMonitor)new NullProgressMonitor());
        this.drReport = this.dpProcessor.getDifferenceReport();
        this.getDifferenceReportsPanel().setTerminologyStyle(this.getTerminologyStyle(this.iCompareType));
        this.getDifferenceReportsPanel().setDifferenceReports(Collections.singletonList(this.drReport));
        if (this.iCompareType == 2) {
            this.getDifferenceReportsPanel().setObjectNames(this.getLeftObjectName(), this.getRightObjectName());
        } else if (this.iCompareType == 1) {
            this.getDifferenceReportsPanel().setObjectNames(this.getRightObjectName(), this.getLeftObjectName());
        }
    }

    private int getTerminologyStyle(int iCompareType) {
        int iTerminology = 1;
        if (iCompareType == 1) {
            iTerminology = 1;
        } else if (iCompareType == 2) {
            iTerminology = 2;
        }
        return iTerminology;
    }

    public ModelResource findModelResource(IResource resource, boolean createIfRequired) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        IProject proj = resource.getProject();
        if (!ModelerCore.hasModelNature((IProject)proj)) {
            return null;
        }
        IPath pathInWorkspace = resource.getProjectRelativePath();
        ModelProject modelProject = ModelerCore.getModelWorkspace().getModelProject((IResource)proj);
        ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)false);
        ModelProject parent = modelProject;
        int numFolders = pathInWorkspace.segmentCount();
        if (resource instanceof IFile) {
            if (!ModelUtil.isModelFile((IResource)resource) && !ModelUtil.isVdbArchiveFile((IResource)resource)) {
                return null;
            }
            --numFolders;
        }
        int i = 0;
        while (i < numFolders) {
            String folderName = pathInWorkspace.segment(i);
            ModelWorkspaceItem child = parent.getChild(folderName);
            if (child == null) {
                IFolder underlyingFolder = proj.getFolder(folderName);
                CoreArgCheck.isNotNull((Object)underlyingFolder);
                ModelFolderImpl newFolder = new ModelFolderImpl(underlyingFolder, (ModelWorkspaceItem)parent);
                Object parentInfo = ((ModelWorkspaceItemImpl)parent).getItemInfo();
                if (parentInfo instanceof ModelFolderInfo) {
                    ((ModelFolderInfo)parentInfo).addChild((ModelWorkspaceItem)newFolder);
                    parent = newFolder;
                } else if (parentInfo instanceof ModelProjectInfo) {
                    ((ModelProjectInfo)parentInfo).addChild((ModelWorkspaceItem)newFolder);
                    parent = newFolder;
                }
            } else {
                parent = child;
            }
            ++i;
        }
        if (resource instanceof IFile) {
            ModelWorkspaceItem result = parent.getChild(resource);
            if (result == null && createIfRequired) {
                String name = resource.getName();
                result = new ModelResourceImpl((ModelWorkspaceItem)parent, name);
            }
            return (ModelResource)result;
        }
        return (ModelResource)parent;
    }

    private DifferenceReportsPanel getDifferenceReportsPanel() {
        if (this.pnlDifferenceReport == null) {
            if (this.iCompareType == 1) {
                this.iTerminology = 1;
            } else if (this.iCompareType == 2) {
                this.iTerminology = 2;
            }
            this.pnlDifferenceReport = new DifferenceReportsPanel(this.cmpParent, TREE_TITLE, DIFF_DESCRIPTOR_TITLE, false, false, false, this.drReport, this.iTerminology);
        }
        String sTitle = DIALOG_TITLE;
        this.pnlDifferenceReport.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", sTitle);
        return this.pnlDifferenceReport;
    }

    private String getRightObjectName() {
        String sResult = EMPTY_STRING;
        sResult = this.iCompareType == 2 ? this.rnRight.getResource().getFullPath().toString() : String.valueOf(this.hiRight.getName()) + " - " + DateFormat.getDateTimeInstance().format(new Date(this.hiRight.getModificationDate()));
        return sResult;
    }

    private String getLeftObjectName() {
        return this.rnLeft.getResource().getFullPath().toString();
    }

    public Widget doFindInputItem(Object o) {
        return null;
    }

    public Widget doFindItem(Object o) {
        return null;
    }

    public void doUpdateItem(Widget w, Object o, boolean b) {
    }

    public List getSelectionFromWidget() {
        return null;
    }

    public void internalRefresh(Object o) {
    }

    public void reveal(Object o) {
    }

    public void setSelectionToWidget(List l, boolean b) {
    }

    public Control getControl() {
        return this.getDifferenceReportsPanel();
    }
}

