/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xsd.procedures;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.modelgenerator.xsd.procedures.BaseTraversalContext;
import org.teiid.designer.modelgenerator.xsd.procedures.IBuilderConstants;
import org.teiid.designer.modelgenerator.xsd.procedures.ProcedureBuilder;
import org.teiid.designer.modelgenerator.xsd.procedures.TraversalContext;
import org.teiid.designer.schema.tools.NameUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;

public class ResultBuilderTraversalContext
extends BaseTraversalContext
implements TraversalContext {
    private ProcedureResult result;
    private Procedure procedure;
    private List<Column> cachedColumns = new ArrayList<Column>();
    public static final String RESPONSE = "response_";
    public static final String XML_IN = "xml_in";

    public ResultBuilderTraversalContext(String procedureName, QName namespace, TraversalContext ctx, ProcedureBuilder builder) {
        super(procedureName, namespace, ctx, builder);
    }

    public ResultBuilderTraversalContext(String procedureName, QName namespace, ProcedureBuilder builder) {
        super(procedureName, namespace, builder);
    }

    @Override
    public void addColumn(String name, XSDTypeDefinition type) throws ModelerCoreException {
        if (this.result == null) {
            this.procedure = this.createProcedure(this.procedureName);
            this.result = this.procedure.getResult();
        }
        Column resultCol = this.factory.createColumn();
        this.result.getColumns().add((Object)resultCol);
        String uniqueName = this.getUniqueName((EObject)resultCol, NameUtil.normalizeName((String)name));
        resultCol.setName(uniqueName);
        resultCol.setNameInSource(uniqueName);
        resultCol.setType(this.datatypeManager.getDatatypeForXsdType((EObject)type));
        this.cachedColumns.add(resultCol);
        this.setReachedResultNode(true);
    }

    Procedure createProcedure(String procedureNameBase) throws ModelWorkspaceException, ModelerCoreException {
        this.procedure = this.factory.createProcedure();
        this.builder.getSchema().getProcedures().add((Object)this.procedure);
        String uniqueName = this.getUniqueName((EObject)this.procedure, RESPONSE + NameUtil.normalizeName((String)procedureNameBase));
        this.procedure.setName(uniqueName);
        this.procedure.setNameInSource(procedureNameBase);
        ProcedureParameter param = this.factory.createProcedureParameter();
        this.procedure.getParameters().add((Object)param);
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setName(XML_IN);
        param.setNameInSource(XML_IN);
        param.setNullable(NullableType.NO_NULLS_LITERAL);
        param.setType(this.datatypeManager.getBuiltInDatatype("XMLLiteral"));
        ProcedureResult result = this.factory.createProcedureResult();
        this.procedure.setResult(result);
        result.setName(String.valueOf(NameUtil.normalizeName((String)procedureNameBase)) + IBuilderConstants.V_FUNC_RESULT);
        result.setNameInSource(procedureNameBase);
        this.builder.addProcedure(procedureNameBase);
        return this.procedure;
    }

    @Override
    public void createTransformation() {
        if (this.procedure != null) {
            StringBuffer sqlString = new StringBuffer();
            sqlString.append(IBuilderConstants.V_FUNC_PREAMBLE);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_SELECT_FROM_T);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_XMLTABLE);
            sqlString.append(IBuilderConstants.V_FUNC_OPEN);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            if (this.getNamespace() != null || !this.getNamespace().getNamespaceURI().isEmpty()) {
                sqlString.append(IBuilderConstants.V_FUNC_XMLNAMESPACES);
                sqlString.append(IBuilderConstants.V_FUNC_OPEN);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_DEFAULT);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_QUOTE);
                sqlString.append(this.getNamespace().getNamespaceURI());
                sqlString.append(IBuilderConstants.V_FUNC_QUOTE);
                sqlString.append(IBuilderConstants.V_FUNC_CLOSE);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_COMMA);
            }
            sqlString.append(IBuilderConstants.V_FUNC_QUOTE);
            sqlString.append(this.getPath());
            sqlString.append(IBuilderConstants.V_FUNC_QUOTE);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_PASSING);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(XML_IN);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_COLUMNS);
            boolean firstTime = true;
            for (Column column : this.cachedColumns) {
                if (!firstTime) {
                    sqlString.append(IBuilderConstants.V_FUNC_COMMA);
                    sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                }
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_DOUBLE_QUOTE);
                sqlString.append(column.getNameInSource());
                sqlString.append(IBuilderConstants.V_FUNC_DOUBLE_QUOTE);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(this.datatypeManager.getRuntimeTypeName(column.getType()));
                firstTime = false;
            }
            sqlString.append(IBuilderConstants.V_FUNC_CLOSE);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_AS_T);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_POSTSCRIPT);
            SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)this.procedure);
            TransformationHelper.setSqlString((Object)root, (String)sqlString.toString(), (int)0, (boolean)true, (Object)this);
            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)root, (Object)this);
        }
    }

    private String getUniqueName(EObject eObject, String proposedName) {
        CoreArgCheck.isNotNull((Object)eObject);
        EStructuralFeature nameFeature = ModelerCore.getModelEditor().getNameFeature(eObject);
        if (nameFeature != null) {
            return this.generateUniqueInternalName(eObject.eContainer() == null ? eObject.eResource().getContents() : eObject.eContainer().eContents(), eObject, nameFeature, proposedName);
        }
        return proposedName;
    }

    private String generateUniqueInternalName(EList siblings, EObject eObject, EStructuralFeature nameFeature, String name) {
        String newName = name;
        if (siblings != null) {
            HashSet<Object> siblingNames = new HashSet<Object>();
            for (EObject child : siblings) {
                if (!eObject.getClass().equals(child.getClass())) continue;
                siblingNames.add(child.eGet(nameFeature));
            }
            boolean foundUniqueName = false;
            int index = 1;
            while (!foundUniqueName) {
                if (siblingNames.contains(newName)) {
                    newName = String.valueOf(name) + String.valueOf(index++);
                    continue;
                }
                foundUniqueName = true;
            }
        }
        return newName;
    }
}

