/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.wizards;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.modelgenerator.xml.IUiConstants;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;
import org.teiid.designer.modelgenerator.xml.wizards.RootElementAccumulatorSource;
import org.teiid.designer.modelgenerator.xml.wizards.StateManager;
import org.teiid.designer.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import org.teiid.designer.schema.tools.model.schema.RootElement;
import org.teiid.designer.ui.common.widget.accumulator.AccumulatorPanel;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatedValuesChangeListener;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

class RootElementsPanel
extends Composite
implements IUiConstants,
IUiConstants.HelpContexts,
IUiConstants.Images,
IAccumulatedValuesChangeListener {
    private static PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();
    private static final String MAPPING_OPTIONS = util.getString("RootElementsPage.mappingOptions", new Object[0]);
    private static final String USE_STRING = util.getString("RootElementsPage.useString", new Object[0]);
    private static final String USE_SCHEMA_TYPE = util.getString("RootElementsPage.useSchemaType", new Object[0]);
    private static final int ACCUMULATOR_RESET_BUTTON_VERTICAL_MARGIN = 4;
    public static final int DOCUMENTS = 1;
    private TableViewer documentsListViewer;
    private AccumulatorPanel documentsAccumulatorPanel = null;
    private ILabelProvider accumulatorsLabelProvider;
    Button useSchemaTypeButton;
    private Button useStringTypeButton;
    XsdAsRelationalImportWizard wizard;
    private StateManager manager;
    private boolean selectionsChanged = false;

    public RootElementsPanel(Composite parent, XsdAsRelationalImportWizard wizard) {
        super(parent, 0);
        this.wizard = wizard;
        this.manager = wizard.getStateManager();
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.accumulatorsLabelProvider = ModelUtilities.getEMFLabelProvider();
        Group documentsAccumulatorComposite = new Group((Composite)this, 0);
        String documentsGroupName = util.getString("RootElementsPage.virtualXMLDocumentsLabel", new Object[0]);
        documentsAccumulatorComposite.setText(documentsGroupName);
        GridLayout documentsAccumulatorCompositeLayout = new GridLayout();
        documentsAccumulatorComposite.setLayout((Layout)documentsAccumulatorCompositeLayout);
        documentsAccumulatorCompositeLayout.marginWidth = 0;
        documentsAccumulatorCompositeLayout.marginHeight = 2;
        RootElementAccumulatorSource documentsAccumulatorSource = new RootElementAccumulatorSource(this);
        String documentsAvailableHdr = util.getString("RootElementsPage.documentsAccumulatorLeftLabel", new Object[0]);
        String documentsSelectedHdr = util.getString("RootElementsPage.documentsAccumulatorRightLabel", new Object[0]);
        this.documentsAccumulatorPanel = new AccumulatorPanel((Composite)documentsAccumulatorComposite, (IAccumulatorSource)documentsAccumulatorSource, new ArrayList(), this.accumulatorsLabelProvider, documentsAvailableHdr, documentsSelectedHdr, 4, -1, -1, -1);
        this.documentsAccumulatorPanel.addAccumulatedValuesChangeListener((IAccumulatedValuesChangeListener)this);
        Group typeGroup = new Group((Composite)this, 0);
        typeGroup.setLayout((Layout)new GridLayout(1, true));
        typeGroup.setLayoutData((Object)new GridData(768));
        typeGroup.setText(MAPPING_OPTIONS);
        this.useStringTypeButton = new Button((Composite)typeGroup, 16);
        this.useStringTypeButton.setSelection(true);
        this.useStringTypeButton.setText(USE_STRING);
        this.useSchemaTypeButton = new Button((Composite)typeGroup, 16);
        this.useSchemaTypeButton.setSelection(false);
        this.useSchemaTypeButton.setText(USE_SCHEMA_TYPE);
        this.useSchemaTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RootElementsPanel.this.wizard.setUseSchemaTypes(RootElementsPanel.this.useSchemaTypeButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.useStringTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RootElementsPanel.this.wizard.setUseSchemaTypes(RootElementsPanel.this.useSchemaTypeButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ArrayList availableRoots;
            try {
                availableRoots = this.manager.getPotentialRoots();
            }
            catch (Exception e) {
                Status status = new Status(4, ((Object)((Object)this.wizard)).getClass().getName(), 4, e.getMessage(), (Throwable)e);
                Shell shell = this.getShell();
                ErrorDialog.openError((Shell)shell, (String)util.getString("RootElementsPage.exception", new Object[0]), (String)e.getMessage(), (IStatus)status);
                return;
            }
            ArrayList<RootElement> selectedRoots = new ArrayList<RootElement>();
            if (availableRoots == null) {
                availableRoots = new ArrayList();
            }
            this.emptyList(this.documentsListViewer);
            for (RootElement root : availableRoots) {
                if (root.isUseAsRoot()) {
                    selectedRoots.add(root);
                    continue;
                }
                this.documentsListViewer.add((Object)root);
            }
            this.documentsAccumulatorPanel.repopulateSelectedItems(selectedRoots);
            this.documentsAccumulatorPanel.availableItemsHaveChanged();
        }
    }

    public void accumulatedValuesChanged(AccumulatorPanel source) {
    }

    private void emptyList(TableViewer listViewer) {
        Table list = listViewer.getTable();
        if (list != null) {
            int count = list.getItemCount();
            int i = count - 1;
            while (i >= 0) {
                Object item = listViewer.getElementAt(i);
                listViewer.remove(item);
                --i;
            }
        }
    }

    public void documentsAccumulatedValuesRemoved(Collection values) {
        for (Object value : values) {
            this.documentsListViewer.add(value);
        }
    }

    public void documentsAccumulatedValuesAdded(Collection values) {
        for (Object value : values) {
            this.documentsListViewer.remove(value);
        }
    }

    public Collection getDocumentsAvailableValues() {
        int count = this.documentsListViewer.getTable().getItemCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        int i = 0;
        while (i < count) {
            Object value = this.documentsListViewer.getElementAt(i);
            values.add(value);
            ++i;
        }
        return values;
    }

    public int getDocumentsAvailableValuesCount() {
        int count = this.documentsListViewer.getTable().getItemCount();
        return count;
    }

    public Collection getDocumentsSelectedAvailableValues() {
        int[] selectionIndices = this.documentsListViewer.getTable().getSelectionIndices();
        ArrayList<Object> selectedValues = new ArrayList<Object>(selectionIndices.length);
        int i = 0;
        while (i < selectionIndices.length) {
            int index = selectionIndices[i];
            selectedValues.add(this.documentsListViewer.getElementAt(index));
            ++i;
        }
        return selectedValues;
    }

    public int getDocumentsSelectedAvailableValuesCount() {
        if (this.documentsListViewer != null) {
            int count = this.documentsListViewer.getTable().getSelectionCount();
            return count;
        }
        return 0;
    }

    public Control documentsCreateControl(Composite parent) {
        this.documentsListViewer = new TableViewer(parent, 2);
        this.documentsListViewer.setLabelProvider((IBaseLabelProvider)this.accumulatorsLabelProvider);
        return this.documentsListViewer.getControl();
    }

    public void documentsAddSelectionListener(SelectionListener listener) {
        this.documentsListViewer.getTable().addSelectionListener(listener);
    }

    public void selectedDocumentsChanged() {
        Collection selectedRoots = this.documentsAccumulatorPanel.getSelectedItems();
        this.manager.setSelectedRoots(selectedRoots);
    }

    public boolean isSelectionsChanged() {
        return this.selectionsChanged;
    }

    public void setSelectionsChanged(boolean selectionsChanged) {
        this.selectionsChanged = selectionsChanged;
    }
}

