/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.wizards;

import java.sql.DatabaseMetaData;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.CaseConversion;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.modelgenerator.xml.XMLExtensionsFilter;
import org.teiid.designer.modelgenerator.xml.jdbc.ui.util.JdbcUiUtil;
import org.teiid.designer.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.dialog.FolderSelectionDialog;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;

final class JdbcImportOptionsPage
extends WizardPage
implements InternalUiConstants.Widgets,
IPersistentWizardPage,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcImportOptionsPage.class);
    private static final String TITLE = JdbcImportOptionsPage.getString("title");
    private static final int COLUMN_COUNT = 3;
    private static final String INITIAL_MESSAGE_ID = "initialMessage";
    private static final String NO_NODEL_TO_UPDATE_MESSAGE_ID = "noModelToUpdateMessage";
    private static final String NAME_LABEL = JdbcImportOptionsPage.getString("nameLabel");
    private static final String FOLDER_LABEL = JdbcImportOptionsPage.getString("folderLabel");
    private static final String UPDATE_CHECKBOX = JdbcImportOptionsPage.getString("updateCheckBox");
    private static final String MODEL_OBJECT_NAMES_GROUP = JdbcImportOptionsPage.getString("modelObjectNamesGroup");
    private static final String NONE_BUTTON = JdbcImportOptionsPage.getString("noneButton");
    private static final String UPPERCASE_BUTTON = JdbcImportOptionsPage.getString("uppercaseButton");
    private static final String LOWERCASE_BUTTON = JdbcImportOptionsPage.getString("lowercaseButton");
    private static final String MODEL_OBJECT_NAMES_DESCRIPTION = JdbcImportOptionsPage.getString("modelObjectNamesDescription");
    private static final String FILE_EXISTS_MESSAGE = JdbcImportOptionsPage.getString("fileExistsMessage", UPDATE_CHECKBOX);
    private static final String NOT_MODEL_PROJECT_MESSAGE = JdbcImportOptionsPage.getString("notModelProjectMessage");
    private static final String NOT_RELATIONAL_MODEL_MESSAGE = JdbcImportOptionsPage.getString("notRelationalModelMessage");
    private static final String READ_ONLY_MODEL_MESSAGE = JdbcImportOptionsPage.getString("readOnlyModelMessage");
    private static final String VIRTUAL_MODEL_MESSAGE = JdbcImportOptionsPage.getString("virtualModelMessage");
    private JdbcDatabase db;
    private JdbcImportSettings importSettings;
    private Text nameText;
    private Text folderText;
    private Button updateCheckBox;
    private Button schemaCheckBox;
    private Button noneButton;
    private Button uppercaseButton;
    private Button lowercaseButton;
    private boolean initd;
    private IContainer folder;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object parameter) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, parameter);
    }

    JdbcImportOptionsPage() {
        super(JdbcImportOptionsPage.class.getSimpleName(), TITLE, null);
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)pg);
        CLabel label = new CLabel(pg, 0);
        label.setText(NAME_LABEL);
        GridData gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nameText = WidgetFactory.createTextField((Composite)pg, (int)768);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcImportOptionsPage.this.nameModified();
            }
        });
        Button btn = WidgetFactory.createButton((Composite)pg, (String)BROWSE_BUTTON);
        btn.setToolTipText(JdbcImportOptionsPage.getString("browseModelButton.tip"));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.browseModelSelected();
            }
        });
        CLabel label2 = new CLabel(pg, 0);
        label2.setText(FOLDER_LABEL);
        GridData gridData2 = new GridData(2);
        gridData2.horizontalSpan = 1;
        label2.setLayoutData((Object)gridData2);
        IContainer folder = ((XsdAsRelationalImportWizard)this.getWizard()).getFolder();
        String name = folder == null ? null : folder.getFullPath().makeRelative().toString();
        this.folderText = WidgetFactory.createTextField((Composite)pg, (int)768, (String)name);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JdbcImportOptionsPage.this.folderModified();
            }
        });
        WidgetFactory.createButton((Composite)pg, (String)BROWSE_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.browseButtonSelected();
            }
        });
        this.updateCheckBox = WidgetFactory.createCheckBox((Composite)pg, (String)UPDATE_CHECKBOX, (int)0, (int)3);
        this.updateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.updateCheckBoxSelected();
            }
        });
        Group modelObjNamesGroup = WidgetFactory.createGroup((Composite)pg, (String)MODEL_OBJECT_NAMES_GROUP, (int)256, (int)3);
        CLabel label3 = new CLabel((Composite)modelObjNamesGroup, 64);
        label3.setText(MODEL_OBJECT_NAMES_DESCRIPTION);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 1;
        label3.setLayoutData((Object)gridData3);
        this.noneButton = WidgetFactory.createRadioButton((Composite)modelObjNamesGroup, (String)NONE_BUTTON);
        this.noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.noneButtonSelected();
            }
        });
        this.uppercaseButton = WidgetFactory.createRadioButton((Composite)modelObjNamesGroup, (String)UPPERCASE_BUTTON);
        this.uppercaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.uppercaseButtonSelected();
            }
        });
        this.lowercaseButton = WidgetFactory.createRadioButton((Composite)modelObjNamesGroup, (String)LOWERCASE_BUTTON);
        this.lowercaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportOptionsPage.this.lowercaseButtonSelected();
            }
        });
    }

    public void saveSettings() {
        IDialogSettings dlgSettings = this.getDialogSettings();
        XsdAsRelationalImportWizard wizard = (XsdAsRelationalImportWizard)this.getWizard();
        JdbcImportSettings importSettings = wizard.getSource().getImportSettings();
        try {
            DatabaseMetaData metadata = wizard.getDatabase().getDatabaseMetaData();
            dlgSettings.put(metadata.getSchemaTerm(), importSettings.isCreateSchemasInModel());
        }
        catch (Exception err) {
            Util.log((Throwable)err);
            WidgetUtil.showError((Throwable)err);
        }
        dlgSettings.put(MODEL_OBJECT_NAMES_GROUP, importSettings.getConvertCaseInModel().getName());
    }

    public boolean updateSelected() {
        if (this.updateCheckBox != null) {
            return this.updateCheckBox.getSelection();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            XsdAsRelationalImportWizard wizard = (XsdAsRelationalImportWizard)this.getWizard();
            this.db = wizard.getDatabase();
            String name = wizard.getModelName();
            this.nameText.setText(name);
            try {
                JdbcSource src = wizard.getSource();
                JdbcPlugin.recordJdbcDatabaseSelections((JdbcSource)src, (JdbcDatabase)this.db);
                this.importSettings = src.getImportSettings();
                if (!this.initd) {
                    this.initd = true;
                    IDialogSettings dlgSettings = this.getDialogSettings();
                    DatabaseMetaData metadata = this.db.getDatabaseMetaData();
                    String catalogTerm = metadata.getCatalogTerm();
                    String schemaTerm = metadata.getSchemaTerm();
                    if (!((XsdAsRelationalImportWizard)this.getWizard()).isUpdatedModel() && dlgSettings.get(catalogTerm) != null) {
                        this.importSettings.setCreateSchemasInModel(dlgSettings.getBoolean(schemaTerm));
                        this.importSettings.setConvertCaseInModel(CaseConversion.get((String)dlgSettings.get(MODEL_OBJECT_NAMES_GROUP)));
                    }
                    if (wizard.getStateManager().isUsingNoCatalog()) {
                        this.importSettings.setCreateCatalogsInModel(false);
                    } else {
                        this.importSettings.setCreateCatalogsInModel(true);
                    }
                }
                switch (this.importSettings.getConvertCaseInModel().getValue()) {
                    case 0: {
                        this.noneButton.setSelection(true);
                        break;
                    }
                    case 1: {
                        this.uppercaseButton.setSelection(true);
                        break;
                    }
                    case 2: {
                        this.lowercaseButton.setSelection(true);
                    }
                }
            }
            catch (Exception err) {
                JdbcUiUtil.showAccessError(err);
            }
            this.validatePage();
            if (this.isPageComplete()) {
                this.setMessage(JdbcImportOptionsPage.getString(INITIAL_MESSAGE_ID, name));
            }
        }
        super.setVisible(visible);
    }

    void browseModelSelected() {
        MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor("http://www.metamatrix.com/metamodels/Relational");
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)JdbcImportOptionsPage.getString("dialog.modelChooser.title"), (String)JdbcImportOptionsPage.getString("dialog.modelChooser.msg"), (boolean)false, (Object)((XsdAsRelationalImportWizard)this.getWizard()).getFolder(), (ViewerFilter)new XMLExtensionsFilter(), (ISelectionStatusValidator)new ModelResourceSelectionValidator(descriptor, false), (ILabelProvider)new ModelExplorerLabelProvider());
        if (resources != null && resources.length > 0) {
            IFile model = (IFile)resources[0];
            IContainer folder = model.getParent();
            this.nameText.setText(model.getName());
            this.folderText.setText(folder == null ? "" : folder.getFullPath().makeRelative().toString());
            this.updateCheckBox.setSelection(true);
            this.updateCheckBoxSelected();
        }
    }

    void browseButtonSelectedOLD() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                try {
                    return ((IContainer)element).getProject().getNature("org.teiid.designer.core.modelNature") != null;
                }
                catch (CoreException err) {
                    Util.log((Throwable)err);
                    return false;
                }
            }
        };
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)((XsdAsRelationalImportWizard)this.getWizard()).getFolder(), (ViewerFilter)filter, (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null) {
            this.folderText.setText(folder.getFullPath().makeRelative().toString());
            this.validatePage();
        }
    }

    void browseButtonSelected() {
        IContainer folder = this.getFolder();
        if (folder != null) {
            this.folderText.setText(folder.getFullPath().makeRelative().toString());
            this.validatePage();
        }
    }

    private IContainer getFolder() {
        ViewerFilter filter = this.getFilter();
        FolderSelectionDialog dlg = new FolderSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dlg.setInitialSelection((Object)((XsdAsRelationalImportWizard)this.getWizard()).getFolder());
        dlg.addFilter(filter);
        dlg.setValidator((ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        dlg.setAllowMultiple(false);
        dlg.setInput((Object)ModelerCore.getWorkspace().getRoot());
        Object[] objs = new Object[1];
        if (dlg.open() == 0) {
            objs = dlg.getResult();
        }
        return objs.length == 0 ? null : (IContainer)objs[0];
    }

    private ViewerFilter getFilter() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean projectOpen;
                boolean result = false;
                if (element instanceof IResource && (projectOpen = ((IResource)element).getProject().isOpen())) {
                    if (element instanceof IProject) {
                        result = true;
                    } else if (element instanceof IFolder) {
                        result = true;
                    }
                }
                return result;
            }
        };
        return filter;
    }

    void folderModified() {
        this.validatePage();
    }

    void lowercaseButtonSelected() {
        if (this.lowercaseButton.getSelection()) {
            this.importSettings.setConvertCaseInModel(CaseConversion.TO_LOWERCASE_LITERAL);
        }
    }

    void nameModified() {
        this.validatePage();
    }

    protected void newFolderButtonSelected(TreeViewer viewer, IContainer folder) {
        NewFolderDialog dlg = new NewFolderDialog(this.getShell(), folder);
        if (dlg.open() == 0) {
            viewer.refresh((Object)folder);
            Object newFolder = dlg.getResult()[0];
            viewer.setSelection((ISelection)new StructuredSelection(newFolder), true);
        }
    }

    void noneButtonSelected() {
        if (this.noneButton.getSelection()) {
            this.importSettings.setConvertCaseInModel(CaseConversion.NONE_LITERAL);
        }
    }

    void schemaCheckBoxSelected() {
        this.importSettings.setCreateSchemasInModel(this.schemaCheckBox.getSelection());
    }

    void updateCheckBoxSelected() {
        IStructuredSelection selection;
        if (this.updateCheckBox.getSelection() && (selection = UiUtil.getStructuredSelection()).size() == 1) {
            try {
                ModelResource model = ModelUtil.getModel((Object)selection.getFirstElement());
                if (model != null && !model.isReadOnly() && model.getModelType().getValue() != ModelType.VIRTUAL) {
                    this.nameText.setText(model.getItemName());
                    return;
                }
            }
            catch (ModelWorkspaceException err) {
                Util.log((Throwable)err);
                WidgetUtil.showError((String)err.getLocalizedMessage());
            }
        }
        this.validatePage();
    }

    void uppercaseButtonSelected() {
        if (this.uppercaseButton.getSelection()) {
            this.importSettings.setConvertCaseInModel(CaseConversion.TO_UPPERCASE_LITERAL);
        }
    }

    private void validatePage() {
        block15: {
            boolean updating = this.updateCheckBox.getSelection();
            try {
                String name;
                IStatus status;
                this.folder = WizardUtil.validateFileAndFolder((Text)this.nameText, (Text)this.folderText, (WizardPage)this, (String)".xmi", (int)(updating ? 0 : 3));
                if (this.folder != null && this.folder.getProject().getNature("org.teiid.designer.core.modelNature") == null) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)NOT_MODEL_PROJECT_MESSAGE, (int)3);
                    this.folder = null;
                }
                if ((status = ModelNameUtil.validate((String)(name = this.nameText.getText()), (String)".xmi", (IContainer)this.folder, (int)5)).getSeverity() == 4) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)(String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage()), (int)3);
                    this.folder = null;
                }
                if (this.isPageComplete()) {
                    IFile file = this.folder.getFile((IPath)new Path(name = FileUtils.toFileNameWithExtension((String)name, (String)".xmi")));
                    if (file.exists()) {
                        try {
                            ModelResource model = ModelerCore.getModelEditor().findModelResource((IResource)file);
                            if (model.isReadOnly()) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)READ_ONLY_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (!"http://www.metamatrix.com/metamodels/Relational".equals(model.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)NOT_RELATIONAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                            if (model.getModelType().getValue() == ModelType.VIRTUAL) {
                                WizardUtil.setPageComplete((WizardPage)this, (String)VIRTUAL_MODEL_MESSAGE, (int)3);
                                return;
                            }
                        }
                        catch (ModelWorkspaceException err) {
                            Util.log((Throwable)err);
                            WidgetUtil.showError((String)err.getLocalizedMessage());
                        }
                    } else if (updating) {
                        WizardUtil.setPageComplete((WizardPage)this, (String)JdbcImportOptionsPage.getString(NO_NODEL_TO_UPDATE_MESSAGE_ID, file.getFullPath().makeRelative()), (int)3);
                        return;
                    }
                    XsdAsRelationalImportWizard wizard = (XsdAsRelationalImportWizard)this.getWizard();
                    wizard.setModelName(name);
                    wizard.setFolder(this.folder);
                    this.getContainer().updateButtons();
                    break block15;
                }
                if (this.folder != null) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)(String.valueOf(this.getMessage()) + '\n' + FILE_EXISTS_MESSAGE), (int)this.getMessageType());
                }
            }
            catch (CoreException err) {
                Util.log((Throwable)err);
                WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
            }
        }
    }

    public boolean canFlipToNextPage() {
        boolean updating = this.updateCheckBox.getSelection();
        IFile file = null;
        if (this.folder != null) {
            String name = this.nameText.getText();
            name = FileUtils.toFileNameWithExtension((String)name, (String)".xmi");
            file = this.folder.getFile((IPath)new Path(name));
        }
        return this.folder != null && file != null && updating && this.isPageComplete() && file.exists();
    }
}

