/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.modelextension;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;
import org.teiid.designer.modelgenerator.xml.modelextension.ExtensionManager;
import org.teiid.designer.modelgenerator.xml.modelextension.ExtensionReplaceAction;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class BaseExtensionReplaceAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction,
ExtensionReplaceAction {
    private List selectedModels;

    public BaseExtensionReplaceAction() {
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK"));
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    @Override
    public abstract ExtensionManager getExtensionManager();

    @Override
    public abstract String getExtensionName();

    public boolean isApplicable(ISelection selection) {
        boolean result = false;
        List selectedObjs = SelectionUtilities.getSelectedObjects((ISelection)selection);
        if (!selectedObjs.isEmpty()) {
            for (Object obj : selectedObjs) {
                if (obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    if (ModelUtilities.isModelFile((IResource)file)) {
                        ModelResource resource = ModelUtilities.getModelResource((Object)file);
                        try {
                            if (ModelUtilities.isPhysical((ModelResource)resource) && ModelUtilities.isRelationalModel((ModelResource)resource)) {
                                List imports = resource.getModelImports();
                                for (ModelImport imp : imports) {
                                    if (!imp.getName().equals(this.getExtensionName()) || ModelUtilities.isModelInWorkspace((String)imp.getUuid())) continue;
                                    result = true;
                                }
                                continue;
                            }
                            result = false;
                        }
                        catch (ModelWorkspaceException modelWorkspaceException) {
                            result = false;
                        }
                        catch (CoreException coreException) {
                            result = false;
                        }
                        break;
                    }
                    result = false;
                    break;
                }
                result = false;
                break;
            }
        }
        return result;
    }

    void replaceExtension(IProgressMonitor monitor) {
        if (this.selectedModels != null) {
            ArrayList<ModelResource> eventList = new ArrayList<ModelResource>();
            ArrayList<ModelResource> modelsToSave = new ArrayList<ModelResource>();
            ExtensionManager manager = null;
            for (IFile modelFile : this.selectedModels) {
                try {
                    ModelResource modelResource = ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
                    try {
                        if (manager == null) {
                            manager = this.getExtensionManager();
                            manager.loadModelExtensions(modelFile.getParent(), monitor);
                        }
                        ModelAnnotation modelAnnotation = modelResource.getModelAnnotation();
                        modelAnnotation.setExtensionPackage(manager.getPackage());
                        ModelBuildUtil.rebuildImports((Resource)modelResource.getEmfResource(), (boolean)true);
                    }
                    catch (ModelWorkspaceException theException) {
                        UiConstants.Util.log(4, (Throwable)theException, theException.getMessage());
                    }
                    catch (ModelerCoreException e) {
                        UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                    }
                    eventList.add(modelResource);
                    if (ModelEditorManager.isOpen((IFile)modelFile)) continue;
                    modelsToSave.add(modelResource);
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            for (ModelResource modelResource : modelsToSave) {
                try {
                    modelResource.save(null, true);
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            for (ModelResource modelResource : eventList) {
                ModelResourceEvent event = new ModelResourceEvent(modelResource, 5, (Object)this);
                UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
            }
        }
    }

    public void run() {
        if (this.selectedModels != null) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor theMonitor) {
                    block14: {
                        String message = XmlImporterUiPlugin.getDefault().getPluginUtil().getString("ReplaceMissingExtensionsAction.TxnMessage", new Object[0]);
                        boolean started = ModelerCore.startTxn((boolean)true, (boolean)true, (String)message, (Object)((Object)this));
                        boolean succeeded = false;
                        try {
                            try {
                                BaseExtensionReplaceAction.this.replaceExtension(theMonitor);
                                succeeded = true;
                            }
                            catch (Exception err) {
                                String msg = XmlImporterUiPlugin.getDefault().getPluginUtil().getString("ReplaceMissingExtensionsAction.errorMessage", new Object[0]);
                                UiConstants.Util.log(4, (Throwable)err, msg);
                                if (started) {
                                    if (succeeded) {
                                        ModelerCore.commitTxn();
                                    } else {
                                        ModelerCore.rollbackTxn();
                                    }
                                }
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            throw throwable;
                        }
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                    theMonitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                UiConstants.Util.log(e.getTargetException());
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.selectedModels = SelectionUtilities.getSelectedObjects((ISelection)selection);
        boolean enable = true;
        if (this.selectedModels.isEmpty()) {
            enable = false;
        } else {
            for (Object obj : this.selectedModels) {
                if (obj instanceof IFile) {
                    if (!ModelUtilities.isModelFile((IResource)((IFile)obj))) {
                        enable = false;
                        break;
                    }
                    try {
                        ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)true);
                        if (modelResource != null && !modelResource.isReadOnly()) continue;
                        enable = false;
                        break;
                    }
                    catch (ModelWorkspaceException e) {
                        UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                        continue;
                    }
                }
                enable = false;
                break;
            }
        }
        this.setEnabled(enable);
    }
}

