/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.designer.ddl.importer.node.AbstractImporter;
import org.teiid.designer.ddl.importer.node.StandardImporter;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalSchema;
import org.teiid.designer.relational.model.RelationalTable;

public class OracleImporter
extends StandardImporter {
    private static final String VARCHAR2_TYPE_NAME = "VARCHAR2";
    private static final String NVARCHAR2_TYPE_NAME = "NVARCHAR2";
    private static final String NUMBER_TYPE_NAME = "NUMBER";

    @Override
    protected RelationalProcedure createProcedure(AstNode procedureNode, RelationalModel model) throws Exception {
        RelationalProcedure procedure = super.createProcedure(procedureNode, model);
        for (AstNode child : procedureNode) {
            if (!this.is(child, "oracleddl:functionParameter")) continue;
            RelationalParameter prm = this.getFactory().createParameter();
            procedure.getParameters().add(prm);
            this.initialize((RelationalReference)prm, child);
            String datatype = child.getProperty("ddl:datatypeName").toString();
            prm.setNativeType(datatype);
            String teiidType = this.getTeiidDataTypeName(datatype);
            prm.setDatatype(teiidType);
            Object prop = child.getProperty("ddl:datatypeLength");
            if (prop != null) {
                prm.setLength(Integer.parseInt(prop.toString()));
            }
            if ((prop = child.getProperty("ddl:datatypePrecision")) != null) {
                prm.setPrecision(Integer.parseInt(prop.toString()));
            }
            if ((prop = child.getProperty("ddl:datatypeScale")) != null) {
                prm.setScale(Integer.parseInt(prop.toString()));
            }
            if ((prop = child.getProperty("ddl:nullable")) != null) {
                prm.setNullable(prop.toString());
            }
            if ((prop = child.getProperty("ddl:defaultValue")) != null) {
                prm.setDefaultValue(prop.toString());
            }
            if ((prop = child.getProperty("oracleddl:inOutNoCopy")) == null) continue;
            String direction = prop.toString();
            prm.setDirection(direction);
        }
        return procedure;
    }

    @Override
    protected Map<AstNode, RelationalReference> createObject(AstNode node, RelationalModel model, RelationalSchema schema) throws Exception {
        HashMap<AstNode, RelationalReference> deferredMap = new HashMap<AstNode, RelationalReference>();
        if (this.is(node, "oracleddl:createTableIndexStatement")) {
            deferredMap.put(node, null);
        } else if (this.is(node, "oracleddl:createProcedureStatement")) {
            this.createProcedure(node, model);
        } else if (this.is(node, "oracleddl:createFunctionStatement")) {
            this.createProcedure(node, model).setFunction(true);
        } else {
            return super.createObject(node, model, schema);
        }
        return deferredMap;
    }

    @Override
    protected void createDeferredObjects(Map<AstNode, RelationalReference> deferredNodes, RelationalModel model) throws Exception {
        RelationalTable table;
        Collection allRefs = model.getAllReferences();
        Set<AstNode> astNodes = deferredNodes.keySet();
        for (AstNode node : astNodes) {
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createPrimaryKey(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (!this.is(node1, "ddl:addTableConstraintDefinition")) continue;
                this.createPrimaryKey(node1, table, allRefs);
            }
        }
        for (AstNode node : astNodes) {
            if (this.is(node, "oracleddl:createTableIndexStatement")) {
                String tableName;
                RelationalTable table2;
                RelationalIndex index = this.getFactory().createIndex();
                StandardImporter.Info info = this.createInfo(node, model);
                if (info.getSchema() == null) {
                    model.addChild((RelationalReference)index);
                } else {
                    info.getSchema().getIndexes().add(index);
                }
                this.initialize((RelationalReference)index, node, info.getName());
                Object prop = node.getProperty("oracleddl:unique");
                if (prop != null) {
                    index.setUnique(((Boolean)prop).booleanValue());
                }
                if ((table2 = this.find(RelationalTable.class, tableName = (String)node.getProperty("oracleddl:tableName"), node, null, allRefs)) == null) continue;
                List childNodes = node.getChildren();
                for (AstNode child : childNodes) {
                    if (!this.is(child, "ddl:columnReference")) continue;
                    try {
                        RelationalColumn col = this.find(RelationalColumn.class, child, (RelationalReference)table2, allRefs);
                        if (col == null) continue;
                        index.getColumns().add(col);
                    }
                    catch (AbstractImporter.EntityNotFoundException error) {
                        this.addProgressMessage(error.getMessage());
                    }
                }
                continue;
            }
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createConstraint(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (this.is(node1, "ddl:addTableConstraintDefinition")) {
                    this.createConstraint(node1, table, allRefs);
                    continue;
                }
                if (!this.is(node1, "ddl:addColumnDefinition")) continue;
                this.createColumn(node1, table);
            }
        }
    }

    @Override
    protected String getTeiidDataTypeName(String jdbcTypeName) throws Exception {
        String standardName = jdbcTypeName;
        if (VARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName) || NVARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
            standardName = "VARCHAR";
        }
        if (NUMBER_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
            standardName = "NUMERIC";
        }
        return super.getTeiidDataTypeName(standardName);
    }
}

