/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.security;

import java.net.URL;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.foundation.security.DescriptiveStorageLoginDialog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DescriptiveDialogPasswordProvider
extends PasswordProvider {
    private static final String JUNIT_APPS1 = "org.eclipse.pde.junit.runtime.";
    private static final String JUNIT_APPS2 = "org.eclipse.test.";

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        String defaultFile;
        if (!this.showUI(container)) {
            return null;
        }
        boolean newPassword = (passwordType & 1) != 0;
        boolean passwordChange = (passwordType & 2) != 0;
        String location = container.getLocation().getFile();
        URL defaultURL = DescriptiveDialogPasswordProvider.defaultStorageLocation();
        if (defaultURL != null && (defaultFile = defaultURL.getFile()) != null && defaultFile.equals(location)) {
            location = null;
        }
        final DescriptiveStorageLoginDialog loginDialog = new DescriptiveStorageLoginDialog(newPassword, passwordChange, location);
        final PBEKeySpec[] result = new PBEKeySpec[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = loginDialog.open() == 0 ? loginDialog.getGeneratedPassword() : null;
            }
        });
        return result[0];
    }

    private boolean showUI(IPreferencesContainer container) {
        Object promptHint;
        if (!PlatformUI.isWorkbenchRunning() || this.isJUnitApp()) {
            return false;
        }
        if (container == null) {
            return true;
        }
        if (container.hasOption((Object)"org.eclipse.equinox.security.storage.promptUser") && (promptHint = container.getOption((Object)"org.eclipse.equinox.security.storage.promptUser")) instanceof Boolean) {
            return (Boolean)promptHint;
        }
        return true;
    }

    private boolean isJUnitApp() {
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        if (context == null) {
            return false;
        }
        String app = context.getProperty("eclipse.application");
        if (app == null) {
            return false;
        }
        if (app.startsWith(JUNIT_APPS1)) {
            return true;
        }
        return app.startsWith(JUNIT_APPS2);
    }

    private static URL defaultStorageLocation() {
        ISecurePreferences defaultStorage = SecurePreferencesFactory.getDefault();
        if (defaultStorage == null) {
            return null;
        }
        return ((SecurePreferencesWrapper)defaultStorage).getContainer().getLocation();
    }
}

