/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.flatfile;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.flatfile.FlatFileRelationalModelWizardPage;
import org.teiid.designer.ui.wizards.INewModelWizardContributor;

public class FlatFileRelationalModelContributor
implements INewModelWizardContributor {
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory factory = RelationalFactory.eINSTANCE;
    public static final DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;
    private IWizardPage[] pages;
    private FlatFileRelationalModelWizardPage flatFilePage;

    public boolean canFinishEarly(IWizardPage theCurrentPage) {
        return false;
    }

    public void createWizardPages(ISelection selection, IResource targetResource, IPath targetFilePath, MetamodelDescriptor descriptor, boolean isVirtual) {
        this.pages = new IWizardPage[1];
        this.flatFilePage = new FlatFileRelationalModelWizardPage("flatFilePage");
        this.pages[0] = this.flatFilePage;
    }

    public void currentPageChanged(IWizardPage page) {
    }

    public void doCancel() {
    }

    public void doFinish(ModelResource modelResource, IProgressMonitor monitor) {
        block12: {
            String transactionName = UiConstants.Util.getString("FlatFileRelationalModelContributor.transactionName", new Object[0]);
            boolean started = ModelerCore.startTxn((String)transactionName, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    if (this.flatFilePage.doGenerateGetFiles()) {
                        this.addGetFilesProcedure(modelResource);
                    }
                    if (this.flatFilePage.doGenerateGetTextFiles()) {
                        this.addGetTextFilesProcedure(modelResource);
                    }
                    if (this.flatFilePage.doGenerateSaveFile()) {
                        this.addSaveFileProcedure(modelResource);
                    }
                    succeeded = true;
                }
                catch (Exception ex) {
                    String message = UiConstants.Util.getString("FlatFileRelationalModelContributor.doFinishError", (Object)modelResource.getItemName());
                    UiConstants.Util.log(4, (Throwable)ex, message);
                    if (!started) break block12;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block12;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void addGetFilesProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject blobType = datatypeManager.findDatatype("blob");
        Procedure proc = factory.createProcedure();
        proc.setName("getFiles");
        ProcedureParameter param = factory.createProcedureParameter();
        param.setName("pathAndExt");
        param.setProcedure(proc);
        if (stringType != null) {
            param.setType(stringType);
        }
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(proc);
        Column column_1 = factory.createColumn();
        column_1.setName("file");
        if (blobType != null) {
            column_1.setType(blobType);
        }
        this.addValue(result, column_1, result.getColumns());
        Column column_2 = factory.createColumn();
        column_2.setName("filePath");
        if (stringType != null) {
            column_2.setType(stringType);
        }
        this.addValue(result, column_2, result.getColumns());
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    private void addGetTextFilesProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject clobType = datatypeManager.findDatatype("clob");
        Procedure proc = factory.createProcedure();
        proc.setName("getTextFiles");
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("pathAndExt");
        param.setProcedure(proc);
        if (stringType != null) {
            param.setType(stringType);
        }
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(proc);
        Column column_1 = factory.createColumn();
        column_1.setName("file");
        if (clobType != null) {
            column_1.setType(clobType);
        }
        this.addValue(result, column_1, result.getColumns());
        Column column_2 = factory.createColumn();
        column_2.setName("filePath");
        if (stringType != null) {
            column_2.setType(stringType);
        }
        this.addValue(result, column_2, result.getColumns());
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    private void addSaveFileProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject objectType = datatypeManager.findDatatype("object");
        Procedure proc = factory.createProcedure();
        proc.setName("saveFile");
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("filePath");
        param.setProcedure(proc);
        if (stringType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("value");
        param.setProcedure(proc);
        if (objectType != null) {
            param.setType(objectType);
        }
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    public void addValue(Object owner, Object value, EList feature) {
        try {
            if (isTransactionable) {
                ModelerCore.getModelEditor().addValue(owner, value, feature);
            } else {
                feature.add(value);
            }
        }
        catch (ModelerCoreException err) {
            UiConstants.Util.log(4, (Throwable)err, UiConstants.Util.getString("FlatFileRelationalModelContributor.addValueError", new Object[]{value, owner}));
        }
    }

    public EList getModelResourceContents(ModelResource resource) {
        EList eList = null;
        try {
            eList = resource.getEmfResource().getContents();
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString("FlatFileRelationalModelContributor.getModelContentsError", (Object)resource.getItemName()));
        }
        return eList;
    }

    public IWizardPage[] getWizardPages() {
        return this.pages;
    }

    public void inputChanged(ISelection selection, IResource targetResource, MetamodelDescriptor descriptor, boolean isVirtual) {
    }
}

