/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.nio.charset.Charset;
import java.util.Set;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQMetaData;
import net.sf.saxon.Version;
import net.sf.saxon.xqj.SaxonXQConnection;

public class SaxonXQMetaData
implements XQMetaData {
    private SaxonXQConnection connection;

    public SaxonXQMetaData(SaxonXQConnection connection) {
        this.connection = connection;
    }

    @Override
    public int getMaxExpressionLength() throws XQException {
        this.checkNotClosed();
        this.checkNotClosed();
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxUserNameLength() throws XQException {
        this.checkNotClosed();
        return Integer.MAX_VALUE;
    }

    @Override
    public int getProductMajorVersion() throws XQException {
        this.checkNotClosed();
        return Version.getStructuredVersionNumber()[0];
    }

    @Override
    public int getProductMinorVersion() throws XQException {
        this.checkNotClosed();
        return Version.getStructuredVersionNumber()[1];
    }

    @Override
    public String getProductName() throws XQException {
        this.checkNotClosed();
        return Version.getProductName();
    }

    @Override
    public String getProductVersion() throws XQException {
        this.checkNotClosed();
        return Version.getProductVersion();
    }

    @Override
    public Set getSupportedXQueryEncodings() throws XQException {
        this.checkNotClosed();
        return Charset.availableCharsets().keySet();
    }

    @Override
    public String getUserName() throws XQException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public int getXQJMajorVersion() throws XQException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public int getXQJMinorVersion() throws XQException {
        this.checkNotClosed();
        return 9;
    }

    @Override
    public String getXQJVersion() throws XQException {
        this.checkNotClosed();
        return "0.9";
    }

    @Override
    public boolean isFullAxisFeatureSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean isModuleFeatureSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean isReadOnly() throws XQException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean isSchemaImportFeatureSupported() throws XQException {
        this.checkNotClosed();
        return this.connection.getConfiguration().isLicensedFeature(3);
    }

    @Override
    public boolean isSchemaValidationFeatureSupported() throws XQException {
        this.checkNotClosed();
        return this.connection.getConfiguration().isLicensedFeature(3);
    }

    @Override
    public boolean isSerializationFeatureSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean isStaticTypingExtensionsSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean isStaticTypingFeatureSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean isTransactionSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean isUserDefinedXMLSchemaTypeSupported() throws XQException {
        this.checkNotClosed();
        return this.connection.getConfiguration().isLicensedFeature(3);
    }

    @Override
    public boolean isXQueryEncodingDeclSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean isXQueryEncodingSupported(String encoding) throws XQException {
        this.checkNotClosed();
        return this.getSupportedXQueryEncodings().contains(encoding);
    }

    @Override
    public boolean isXQueryXSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean wasCreatedFromJDBCConnection() throws XQException {
        this.checkNotClosed();
        return false;
    }

    private void checkNotClosed() throws XQException {
        this.connection.checkNotClosed();
    }
}

