/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;

public final class JAXPVariable
implements VariableDeclaration,
Binding {
    private StructuredQName name;
    private XPathVariableResolver resolver;

    protected JAXPVariable(StructuredQName name, XPathVariableResolver resolver) {
        this.name = name;
        this.resolver = resolver;
    }

    @Override
    public SequenceType getRequiredType() {
        return SequenceType.ANY_SEQUENCE;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public final boolean isAssignable() {
        return false;
    }

    @Override
    public int getLocalSlotNumber() {
        return -1;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.name;
    }

    @Override
    public void registerReference(BindingReference ref) {
        ref.setStaticType(SequenceType.ANY_SEQUENCE, null, 0);
        ref.fixup(this);
    }

    @Override
    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        Configuration config = context.getConfiguration();
        Object value = this.resolver.resolveVariable(this.name.toJaxpQName());
        if (value == null) {
            return EmptySequence.getInstance();
        }
        JPConverter converter = JPConverter.allocate(value.getClass(), config);
        return converter.convert(value, context);
    }

    QName makeQName(QNameValue in) {
        return new QName(in.getNamespaceURI(), in.getLocalName(), in.getPrefix());
    }
}

