/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.NextMatch;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLNextMatch
extends StyleElement {
    private boolean useTailRecursion = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainFallback() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            this.checkUnknownAttribute(nc);
            ++a;
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:next-match", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + child.getDisplayName() + " is not allowed within xsl:next-match", "XTSE0010");
        }
    }

    @Override
    protected boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        NextMatch inst = new NextMatch(this.useTailRecursion);
        inst.setActualParameters(this.getWithParamInstructions(exec, false, inst), this.getWithParamInstructions(exec, true, inst));
        return inst;
    }
}

