/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.JDK15RegexTranslator;
import net.sf.saxon.regex.JRegexIterator;
import net.sf.saxon.regex.JTokenIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;

public class JRegularExpression
implements RegularExpression {
    Pattern pattern;
    String javaRegex;
    int flagBits;

    public JRegularExpression(String javaRegex, int flagBits) {
        this.flagBits = flagBits;
        this.javaRegex = javaRegex;
        this.pattern = Pattern.compile(javaRegex, flagBits & 0xFFFFFFFB);
    }

    public JRegularExpression(CharSequence regex, int xmlVersion, int syntax, int flagBits) throws XPathException {
        this.flagBits = flagBits;
        try {
            if (syntax == 2) {
                this.javaRegex = regex.toString();
                this.pattern = Pattern.compile(this.javaRegex, flagBits);
            } else {
                boolean ignoreWhitespace = (flagBits & 4) != 0;
                boolean caseBlind = (flagBits & 2) != 0;
                this.javaRegex = JDK15RegexTranslator.translate(regex, xmlVersion, syntax == 0, ignoreWhitespace, caseBlind);
                this.pattern = Pattern.compile(this.javaRegex, flagBits & 0xFFFFFFFB);
            }
        }
        catch (RegexSyntaxException e) {
            XPathException err = new XPathException(e.getMessage());
            err.setErrorCode("FORX0002");
            throw err;
        }
    }

    public String getJavaRegularExpression() {
        return this.javaRegex;
    }

    public int getFlagBits() {
        return this.flagBits;
    }

    @Override
    public RegexIterator analyze(CharSequence input) {
        return new JRegexIterator(input.toString(), this.pattern);
    }

    @Override
    public boolean containsMatch(CharSequence input) {
        return this.pattern.matcher(input).find();
    }

    @Override
    public boolean matches(CharSequence input) {
        return this.pattern.matcher(input).matches();
    }

    @Override
    public CharSequence replace(CharSequence input, CharSequence replacement) throws XPathException {
        Matcher matcher = this.pattern.matcher(input);
        try {
            return matcher.replaceAll(replacement.toString());
        }
        catch (IndexOutOfBoundsException e) {
            int gps = matcher.groupCount();
            if (gps >= 9) {
                throw e;
            }
            String r = replacement.toString();
            String f = "\\$[" + (gps + 1) + "-9]";
            String rep = Pattern.compile(f).matcher(r).replaceAll("");
            return matcher.replaceAll(rep);
        }
    }

    @Override
    public SequenceIterator tokenize(CharSequence input) {
        if (input.length() == 0) {
            return EmptyIterator.getInstance();
        }
        return new JTokenIterator(input, this.pattern);
    }

    public static int setFlags(CharSequence inFlags) throws XPathException {
        int flags = 1;
        int i = 0;
        while (i < inFlags.length()) {
            char c = inFlags.charAt(i);
            switch (c) {
                case 'm': {
                    flags |= 8;
                    break;
                }
                case 'i': {
                    flags |= 2;
                    flags |= 0x40;
                    break;
                }
                case 's': {
                    flags |= 0x20;
                    break;
                }
                case 'x': {
                    flags |= 4;
                    break;
                }
                default: {
                    XPathException err = new XPathException("Invalid character '" + c + "' in regular expression flags");
                    err.setErrorCode("FORX0001");
                    throw err;
                }
            }
            ++i;
        }
        return flags;
    }

    public static void main(String[] args) {
        System.err.println(System.getProperty("java.version"));
        Pattern p = Pattern.compile("([aA])(?:\\1)", 1);
        System.err.println("Find: " + p.matcher("aA").find());
    }
}

