/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpace
extends SystemFunction {
    @Override
    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            d |= 2;
        }
        return d;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.argument.length == 0 && contextItemType == null) {
            XPathException err = new XPathException("The context item for normalize-space() is undefined");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral((Value)((Object)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        if (this.argument.length == 0) {
            Item item = c.getContextItem();
            if (item == null) {
                this.dynamicError("Context item for normalize-space() is undefined", "FONC0001", c);
                return null;
            }
            return StringValue.makeStringValue(Whitespace.collapseWhitespace(item.getStringValueCS()));
        }
        AtomicValue sv = (AtomicValue)this.argument[0].evaluateItem(c);
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        return StringValue.makeStringValue(Whitespace.collapseWhitespace(sv.getStringValueCS()));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        CharSequence cs;
        if (this.argument.length == 0) {
            Item item = c.getContextItem();
            if (item == null) {
                this.dynamicError("Context item for normalize-space() is undefined", "FONC0001", c);
                return false;
            }
            cs = item.getStringValueCS();
        } else {
            AtomicValue sv = (AtomicValue)this.argument[0].evaluateItem(c);
            if (sv == null) {
                return false;
            }
            cs = sv.getStringValueCS();
        }
        return !Whitespace.isWhite(cs);
    }
}

