/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.PluginConstants;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.editor.BindingAdapter;
import org.teiid.designer.mapping.ui.editor.BindingList;
import org.teiid.designer.mapping.ui.editor.IBindingListViewer;
import org.teiid.designer.mapping.ui.editor.InputSetAdapter;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class InputSetPanel
extends SashForm
implements SelectionListener,
UiConstants {
    private static final int BUTTON_GRID_STYLE = 320;
    private static final String ATTRIBUTE_COL_TEXT = UiConstants.Util.getString("InputSetObjectEditorPage.attributeCol.text", new Object[0]);
    private static final String BINDING_COL_TEXT = UiConstants.Util.getString("InputSetObjectEditorPage.bindingCol.text", new Object[0]);
    private static final String NEW_BUTTON_TEXT = UiConstants.Util.getString("InputSetObjectEditorPage.newButton.text", new Object[0]);
    private static final String NEW_BUTTON_TOOLTIP = UiConstants.Util.getString("InputSetObjectEditorPage.newButton.toolTip", new Object[0]);
    private static final String BIND_BUTTON_TEXT = UiConstants.Util.getString("InputSetObjectEditorPage.bindButton.text", new Object[0]);
    private static final String BIND_BUTTON_TOOLTIP = UiConstants.Util.getString("InputSetObjectEditorPage.bindButton.toolTip", new Object[0]);
    private static final String UNBIND_BUTTON_TEXT = UiConstants.Util.getString("InputSetObjectEditorPage.unbindButton.text", new Object[0]);
    private static final String UNBIND_BUTTON_TOOLTIP = UiConstants.Util.getString("InputSetObjectEditorPage.unbindButton.toolTip", new Object[0]);
    private static final String DELETE_BUTTON_TEXT = UiConstants.Util.getString("InputSetObjectEditorPage.deleteButton.text", new Object[0]);
    private static final String DELETE_BUTTON_TOOLTIP = UiConstants.Util.getString("InputSetObjectEditorPage.deleteButton.toolTip", new Object[0]);
    private static final String TREE_TOOLTIP = UiConstants.Util.getString("InputSetObjectEditorPage.tree.toolTip", new Object[0]);
    private static final String UNDO_NEW = UiConstants.Util.getString("InputSetPanel.undoNew", new Object[0]);
    private static final String UNDO_BIND = UiConstants.Util.getString("InputSetPanel.undoBind", new Object[0]);
    private static final String UNDO_UNBIND = UiConstants.Util.getString("InputSetPanel.undoUnbind", new Object[0]);
    private static final String UNDO_DELETE = UiConstants.Util.getString("InputSetPanel.undoDelete", new Object[0]);
    private static final String UNDO_DELETE_MANY = UiConstants.Util.getString("InputSetPanel.undoDeleteMany", new Object[0]);
    private static final String PARAM_BASE_NAME = UiConstants.Util.getString("InputSetObjectEditorPage.inputParamBaseName.text", new Object[0]);
    private Table table;
    TableViewer tableViewer;
    private Button btnNewButton;
    private Button btnBindButton;
    private Button btnUnbindButton;
    private Button btnDeleteButton;
    private Composite pnlTreePanel;
    private TreeViewer tvTreeViewer;
    private TreeContentProvider treeContentProvider;
    InputSetAdapter isoInputSetObject;
    private BindingContentProvider cpBindingContentProvider;
    private BindingLabelProvider lpBindingLabelProvider;
    private TreeMappingAdapter mappingAdapter;
    private IMappableTree mappableTree;
    String[] columnNames = new String[]{ATTRIBUTE_COL_TEXT, BINDING_COL_TEXT};

    public InputSetPanel(Composite parent) {
        super(parent, 512);
        this.createControl((Composite)this);
    }

    private void init() {
        if (this.isoInputSetObject != null) {
            this.getBindingList().addChangeListener(new BindingChangeHandler());
        }
        InputParameter sampleInputParam = null;
        sampleInputParam = this.getBindingList().size() > 0 ? (InputParameter)this.getBindingList().get(0).getItem() : TransformationFactory.eINSTANCE.createInputParameter();
        IPropertySource propertySource = ModelUtilities.getEmfPropertySourceProvider().getPropertySource((Object)sampleInputParam);
        IPropertyDescriptor[] properties = propertySource.getPropertyDescriptors();
        CellEditor[] cellEditors = new CellEditor[2];
        cellEditors[0] = properties[0].createPropertyEditor((Composite)this.table);
        this.columnNames[0] = properties[0].getDisplayName();
        this.tableViewer.setColumnProperties(this.columnNames);
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new InputParameterNameModifier(properties[0]));
        this.tableViewer.setInput((Object)this.getBindingList());
        this.setButtonStates();
        if (this.mappingAdapter != null) {
            List parentMappingClasses = this.mappingAdapter.getParentMappingClasses(this.isoInputSetObject.getInputSet().getMappingClass(), this.mappableTree, false);
            this.tvTreeViewer.setInput((Object)parentMappingClasses);
        }
        this.table.addSelectionListener((SelectionListener)this);
    }

    public void setBusinessObject(InputSetAdapter iso) {
        this.isoInputSetObject = iso;
        this.init();
    }

    public void setMappingAdapters(TreeMappingAdapter adapter, IMappableTree tree) {
        this.mappingAdapter = adapter;
        this.mappableTree = tree;
    }

    public void refreshFromBusinessObject() {
        this.tableViewer.refresh(true);
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        this.setLayoutData(gridData);
        SashForm splitter = new SashForm(parent, 256);
        this.createTableViewerPanel((Composite)splitter);
        Composite outerComposite = new Composite((Composite)splitter, 0);
        gridLayout = new GridLayout();
        outerComposite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        this.createControlButtonPanel(outerComposite);
        this.createTree(outerComposite);
    }

    private void createControlButtonPanel(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        buttonComposite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(4);
        buttonComposite.setLayoutData((Object)gridData);
        this.btnNewButton = WidgetFactory.createButton((Composite)buttonComposite, (String)NEW_BUTTON_TEXT, (int)320);
        this.btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputSetPanel.this.newButtonPressed();
            }
        });
        this.btnNewButton.setToolTipText(NEW_BUTTON_TOOLTIP);
        this.btnBindButton = WidgetFactory.createButton((Composite)buttonComposite, (String)BIND_BUTTON_TEXT, (int)320);
        this.btnBindButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputSetPanel.this.bindButtonPressed();
            }
        });
        this.btnBindButton.setToolTipText(BIND_BUTTON_TOOLTIP);
        this.btnUnbindButton = WidgetFactory.createButton((Composite)buttonComposite, (String)UNBIND_BUTTON_TEXT, (int)320);
        this.btnUnbindButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputSetPanel.this.unbindButtonPressed();
            }
        });
        this.btnUnbindButton.setToolTipText(UNBIND_BUTTON_TOOLTIP);
        this.btnDeleteButton = WidgetFactory.createButton((Composite)buttonComposite, (String)DELETE_BUTTON_TEXT, (int)320);
        this.btnDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputSetPanel.this.deleteButtonPressed();
            }
        });
        this.btnDeleteButton.setToolTipText(DELETE_BUTTON_TOOLTIP);
    }

    private void createTable(Composite parent) {
        int style = 68354;
        this.table = new Table(parent, style);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.table, 16384, 0);
        column1.setText(ATTRIBUTE_COL_TEXT);
        ColumnWeightData weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column2 = new TableColumn(this.table, 16384, 1);
        column2.setText(BINDING_COL_TEXT);
        weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
    }

    private void createTableViewerPanel(Composite parent) {
        this.createTable(parent);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.cpBindingContentProvider = new BindingContentProvider();
        this.lpBindingLabelProvider = new BindingLabelProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.cpBindingContentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.lpBindingLabelProvider);
        this.tableViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent theEvent) {
                InputSetPanel.this.handleTableSelection();
            }

            public void widgetSelected(SelectionEvent theEvent) {
                InputSetPanel.this.handleTableSelection();
            }
        });
    }

    protected void createTree(Composite theParent) {
        this.pnlTreePanel = new Composite(theParent, 0);
        this.pnlTreePanel.setLayoutData((Object)new GridData(1808));
        this.pnlTreePanel.setLayout((Layout)new FillLayout());
        this.tvTreeViewer = this.createTreeViewer(this.pnlTreePanel);
        Tree tree = this.tvTreeViewer.getTree();
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent theEvent) {
                InputSetPanel.this.handleTreeSelection();
            }

            public void widgetSelected(SelectionEvent theEvent) {
                InputSetPanel.this.handleTreeSelection();
            }
        });
        tree.setToolTipText(TREE_TOOLTIP);
    }

    public TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        this.treeContentProvider = new TreeContentProvider();
        viewer.setContentProvider((IContentProvider)this.treeContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)ModelUtilities.getEMFLabelProvider());
        return viewer;
    }

    void handleTreeSelection() {
        this.setButtonStates();
    }

    void handleTableSelection() {
        BindingAdapter binding;
        Object mapping;
        this.setButtonStates();
        List tableSelection = SelectionUtilities.getSelectedObjects((ISelection)this.tableViewer.getSelection());
        if (tableSelection.size() == 1 && (mapping = (binding = (BindingAdapter)tableSelection.get(0)).getMapping()) != null) {
            this.tvTreeViewer.setSelection((ISelection)new StructuredSelection(mapping));
        }
    }

    BindingList getBindingList() {
        return this.isoInputSetObject.getBindingList();
    }

    void bindButtonPressed() {
        boolean started = ModelerCore.startTxn((String)UNDO_BIND, (Object)this);
        boolean succeeded = false;
        try {
            ISelection is = this.tvTreeViewer.getSelection();
            EObject mcColumn = SelectionUtilities.getSelectedEObject((ISelection)is);
            is = this.tableViewer.getSelection();
            BindingAdapter bindingAdapter = (BindingAdapter)SelectionUtilities.getSelectedObject((ISelection)is);
            if (bindingAdapter != null) {
                bindingAdapter.setMapping(mcColumn);
                this.refreshFromBusinessObject();
            }
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.setButtonStates();
    }

    void unbindButtonPressed() {
        block15: {
            boolean started = ModelerCore.startTxn((String)UNDO_UNBIND, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    ISelection is = this.tableViewer.getSelection();
                    BindingAdapter bindingAdapter = (BindingAdapter)SelectionUtilities.getSelectedObject((ISelection)is);
                    if (bindingAdapter != null) {
                        bindingAdapter.setMapping(null);
                        bindingAdapter.deleteBinding();
                    }
                    succeeded = true;
                }
                catch (ModelerCoreException e) {
                    UiConstants.Util.log((Throwable)e);
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.refreshFromBusinessObject();
        this.setButtonStates();
    }

    void newButtonPressed() {
        boolean started = ModelerCore.startTxn((String)UNDO_NEW, (Object)this);
        boolean succeeded = false;
        try {
            InputParameter param = TransformationFactory.eINSTANCE.createInputParameter();
            InputSet inputSet = this.isoInputSetObject.getInputSet();
            param.setInputSet(inputSet);
            EObject treeSelection = SelectionUtilities.getSelectedEObject((ISelection)this.tvTreeViewer.getSelection());
            if (treeSelection instanceof MappingClassColumn) {
                param.setName(((MappingClassColumn)treeSelection).getName());
            } else {
                treeSelection = null;
                int nameIndex = this.getBindingList().size();
                String name = String.valueOf(PARAM_BASE_NAME) + ++nameIndex;
                boolean tryAgain = true;
                while (tryAgain) {
                    tryAgain = false;
                    Iterator iter = inputSet.getInputParameters().iterator();
                    while (iter.hasNext()) {
                        if (!name.equals(((InputParameter)iter.next()).getName())) continue;
                        name = String.valueOf(PARAM_BASE_NAME) + ++nameIndex;
                        tryAgain = true;
                    }
                }
                param.setName(name);
            }
            BindingAdapter binding = null;
            binding = treeSelection != null ? new BindingAdapter(param, treeSelection) : new BindingAdapter(param);
            this.getBindingList().add(binding);
            this.refreshFromBusinessObject();
            this.setButtonStates();
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    void deleteButtonPressed() {
        block15: {
            List tableSelection = SelectionUtilities.getSelectedObjects((ISelection)this.tableViewer.getSelection());
            boolean started = false;
            boolean succeeded = false;
            started = tableSelection.size() == 1 ? ModelerCore.startTxn((String)UNDO_DELETE, (Object)this) : ModelerCore.startTxn((String)UNDO_DELETE_MANY, (Object)this);
            try {
                try {
                    for (BindingAdapter binding : tableSelection) {
                        binding.delete();
                        this.getBindingList().remove(binding);
                    }
                    succeeded = true;
                }
                catch (ModelerCoreException e) {
                    UiConstants.Util.log((Throwable)e);
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.refreshFromBusinessObject();
        this.setButtonStates();
    }

    private void setButtonStates() {
        if (ModelObjectUtilities.isReadOnly((EObject)this.isoInputSetObject.getInputSet())) {
            this.btnNewButton.setEnabled(false);
            this.btnDeleteButton.setEnabled(false);
            this.btnBindButton.setEnabled(false);
            this.btnUnbindButton.setEnabled(false);
        } else {
            BindingAdapter binding;
            this.btnDeleteButton.setEnabled(!this.tableViewer.getSelection().isEmpty());
            boolean enable = false;
            EObject treeSelection = SelectionUtilities.getSelectedEObject((ISelection)this.tvTreeViewer.getSelection());
            if (treeSelection instanceof MappingClassColumn) {
                enable = true;
            }
            this.btnNewButton.setEnabled(true);
            enable = false;
            List tableSelection = SelectionUtilities.getSelectedObjects((ISelection)this.tableViewer.getSelection());
            if (tableSelection.size() == 1 && !(binding = (BindingAdapter)tableSelection.get(0)).isBound() && (treeSelection = SelectionUtilities.getSelectedEObject((ISelection)this.tvTreeViewer.getSelection())) instanceof MappingClassColumn) {
                enable = true;
            }
            this.btnBindButton.setEnabled(enable);
            enable = false;
            tableSelection = SelectionUtilities.getSelectedObjects((ISelection)this.tableViewer.getSelection());
            if (tableSelection.size() == 1 && (binding = (BindingAdapter)tableSelection.get(0)).isBound()) {
                enable = true;
            }
            this.btnUnbindButton.setEnabled(enable);
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    class BindingChangeHandler
    implements IBindingListViewer {
        BindingChangeHandler() {
        }

        @Override
        public void addBinding(BindingAdapter binding) {
        }

        @Override
        public void insertBinding(BindingAdapter binding, int index) {
        }

        @Override
        public void addBindings(Object[] bindings) {
        }

        @Override
        public void removeBinding(BindingAdapter binding) {
        }

        @Override
        public void removeBindings(Object[] bindings) {
        }

        @Override
        public void updateBinding(BindingAdapter binding) {
        }

        @Override
        public void refresh(boolean updateLabels) {
        }
    }

    class BindingContentProvider
    implements IStructuredContentProvider,
    IBindingListViewer {
        BindingContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((BindingList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((BindingList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            InputSetPanel.this.getBindingList().removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return InputSetPanel.this.getBindingList().getAll().toArray();
        }

        @Override
        public void addBinding(BindingAdapter binding) {
            InputSetPanel.this.tableViewer.add((Object)binding);
        }

        @Override
        public void insertBinding(BindingAdapter binding, int index) {
            InputSetPanel.this.tableViewer.insert((Object)binding, index);
        }

        @Override
        public void addBindings(Object[] bindings) {
            InputSetPanel.this.tableViewer.add(bindings);
        }

        @Override
        public void removeBinding(BindingAdapter binding) {
            InputSetPanel.this.tableViewer.remove((Object)binding);
        }

        @Override
        public void removeBindings(Object[] bindings) {
            InputSetPanel.this.tableViewer.remove(bindings);
        }

        @Override
        public void updateBinding(BindingAdapter binding) {
            InputSetPanel.this.tableViewer.update((Object)binding, null);
        }

        @Override
        public void refresh(boolean updateLabels) {
            InputSetPanel.this.tableViewer.refresh(updateLabels);
        }
    }

    class BindingLabelProvider
    extends ModelExplorerLabelProvider
    implements ITableLabelProvider,
    PluginConstants.Images {
        private static final String EMPTY_STRING = "";

        BindingLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = EMPTY_STRING;
            BindingAdapter binding = (BindingAdapter)element;
            switch (columnIndex) {
                case 0: {
                    Object attr = binding.getItem();
                    if (attr != null && attr instanceof EObject) {
                        result = super.getText(attr);
                        break;
                    }
                    if (!(attr instanceof String)) break;
                    result = (String)attr;
                    break;
                }
                case 1: {
                    Object column = binding.getMapping();
                    if (column != null && column instanceof EObject) {
                        result = String.valueOf(super.getText((Object)((EObject)column).eContainer())) + '.';
                        result = String.valueOf(result) + super.getText(column);
                        break;
                    }
                    if (!(column instanceof String)) break;
                    result = (String)column;
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            BindingAdapter binding = (BindingAdapter)element;
            switch (columnIndex) {
                case 0: {
                    Object attr = binding.getItem();
                    if (attr == null || !(attr instanceof EObject)) break;
                    image = super.getImage(attr);
                    break;
                }
                case 1: {
                    Object column = binding.getMapping();
                    if (column == null || !(column instanceof EObject)) break;
                    image = super.getImage(column);
                    break;
                }
            }
            return image;
        }
    }

    class InputParameterNameModifier
    implements ICellModifier {
        private String propertyName;
        private IPropertyDescriptor descriptor;

        public InputParameterNameModifier(IPropertyDescriptor descriptor) {
            this.propertyName = InputSetPanel.this.columnNames[0];
            this.descriptor = descriptor;
        }

        public boolean canModify(Object element, String property) {
            return this.propertyName.equals(property) && !ModelObjectUtilities.isReadOnly((EObject)InputSetPanel.this.isoInputSetObject.getInputSet());
        }

        public Object getValue(Object element, String property) {
            if (element instanceof BindingAdapter) {
                Object input = ((BindingAdapter)element).getItem();
                IPropertySource propertySource = ModelUtilities.getEmfPropertySourceProvider().getPropertySource(input);
                Object value = propertySource.getPropertyValue(this.descriptor.getId());
                if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper) {
                    value = ((ItemPropertyDescriptor.PropertyValueWrapper)value).getEditableValue(value);
                }
                return value;
            }
            IPropertySource propertySource = ModelUtilities.getEmfPropertySourceProvider().getPropertySource(element);
            return propertySource.getPropertyValue(this.descriptor.getId());
        }

        public void modify(Object element, String property, Object value) {
            if (!this.isNullOrEmptyString(value)) {
                if (element instanceof BindingAdapter) {
                    Object input = ((BindingAdapter)element).getItem();
                    IPropertySource propertySource = ModelUtilities.getEmfPropertySourceProvider().getPropertySource(input);
                    propertySource.setPropertyValue(this.descriptor.getId(), value);
                } else if (element instanceof TableItem) {
                    Object input = ((TableItem)element).getData();
                    this.modify(input, property, value);
                } else {
                    IPropertySource propertySource = ModelUtilities.getEmfPropertySourceProvider().getPropertySource(element);
                    propertySource.setPropertyValue(this.descriptor.getId(), value);
                }
            }
            InputSetPanel.this.refreshFromBusinessObject();
        }

        private boolean isNullOrEmptyString(Object value) {
            String strValue;
            boolean result = false;
            if (value == null) {
                result = true;
            } else if (value instanceof String && (strValue = (String)value).trim().length() == 0) {
                result = true;
            }
            return result;
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof MappingClass) {
                return ((MappingClass)parentElement).getColumns().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof MappingClassColumn) {
                return ((MappingClassColumn)element).getMappingClass();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof MappingClass;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((Collection)parent).toArray();
        }
    }
}

