/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.diagram;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.pakkage.IPackageDiagramProvider;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class MappingDiagramProvider
implements IPackageDiagramProvider {
    public Diagram getPackageDiagram(ModelResource modelResource, EObject eObject, boolean forceCreate) {
        Diagram mappingDiagram = null;
        if (modelResource != null && eObject != null && ModelMapperFactory.isTreeRoot((EObject)eObject)) {
            mappingDiagram = this.getMappingDiagram(modelResource, eObject, forceCreate);
        }
        return mappingDiagram;
    }

    private Diagram createMappingDiagram(EObject target, ModelResource modelResource) {
        Diagram result;
        block9: {
            result = null;
            boolean requiresStart = false;
            boolean succeeded = false;
            boolean persist = false;
            try {
                try {
                    requiresStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create Mapping Diagram", (Object)this);
                    result = modelResource.getModelDiagrams().createNewDiagram(target, persist);
                    result.setType("mappingDiagramType");
                    succeeded = true;
                }
                catch (ModelWorkspaceException e) {
                    String message = UiConstants.Util.getString("MappingDiagramProvider.createMappingDiagramError", (Object)modelResource.toString());
                    UiConstants.Util.log(4, (Throwable)e, message);
                    if (!requiresStart) break block9;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block9;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiresStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return result;
    }

    private Diagram getMappingDiagram(ModelResource modelResource, EObject eObject, boolean forceCreate) {
        Object mappingDiagram = null;
        try {
            ArrayList diagramList = new ArrayList(modelResource.getModelDiagrams().getDiagrams(eObject));
            Iterator iter = diagramList.iterator();
            Diagram nextDiagram = null;
            while (iter.hasNext()) {
                nextDiagram = (Diagram)iter.next();
                if (nextDiagram == null || nextDiagram.getType() == null || !nextDiagram.getType().equals("mappingDiagramType")) continue;
                mappingDiagram = nextDiagram;
            }
        }
        catch (ModelWorkspaceException e) {
            String message = UiConstants.Util.getString("MappingDiagramContentProvider.getTransformationDiagramError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)e, message);
        }
        if (mappingDiagram == null) {
            mappingDiagram = forceCreate ? this.createMappingDiagram(eObject, modelResource) : new DiagramProxy(eObject, "mappingDiagramType", modelResource);
        }
        return mappingDiagram;
    }

    public Diagram getPackageDiagram(Object targetObject, boolean forceCreate) {
        Diagram mappingDiagram = null;
        EObject treeRootEObject = null;
        ModelResource modelResource = null;
        if (targetObject instanceof EObject) {
            EObject eObject = (EObject)targetObject;
            modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
            treeRootEObject = MappingDiagramUtil.getTreeRoot(eObject);
        }
        if (treeRootEObject != null && modelResource != null) {
            mappingDiagram = this.getMappingDiagram(modelResource, treeRootEObject, forceCreate);
        }
        return mappingDiagram;
    }

    public Diagram getDetailedMappingDiagram(EObject targetEObject) {
        EObject tableTarget;
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)targetEObject);
        Iterator iter = null;
        EObject eObject = targetEObject;
        if (TransformationHelper.isTransformationMappingRoot((Object)eObject)) {
            tableTarget = TransformationHelper.getTransformationTarget((Object)eObject);
            if (tableTarget != null) {
                eObject = tableTarget;
            }
        } else {
            tableTarget = DiagramUiUtilities.getParentClassifier((EObject)targetEObject);
            if (tableTarget != null) {
                eObject = tableTarget;
            }
        }
        try {
            iter = modelResource.getModelDiagrams().getDiagrams(eObject).iterator();
        }
        catch (ModelWorkspaceException e) {
            String message = UiConstants.Util.getString("MappingDiagramProvider.getDiagramsError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)e, message);
        }
        if (iter != null) {
            Diagram nextDiagram = null;
            while (iter.hasNext()) {
                nextDiagram = (Diagram)iter.next();
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals("mappingTransformationDiagramType")) continue;
                return nextDiagram;
            }
        }
        boolean requiresStart = false;
        boolean succeeded = false;
        try {
            requiresStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create Mapping Transformation Diagram", (Object)this);
            Diagram depDiagram = modelResource.getModelDiagrams().createNewDiagram(eObject, false);
            depDiagram.setType("mappingTransformationDiagramType");
            succeeded = true;
            Diagram diagram = depDiagram;
            return diagram;
        }
        catch (ModelWorkspaceException mwe) {
            String message = UiConstants.Util.getString("MappingDiagramProvider.createMappingDiagramError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)mwe, message);
        }
        finally {
            if (requiresStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasDetailedMappingDiagram(ModelResource modelResource, EObject eObject) {
        try {
            ArrayList diagramList = new ArrayList(modelResource.getModelDiagrams().getDiagrams(eObject));
            Iterator iter = diagramList.iterator();
            Diagram nextDiagram = null;
            do {
                if (iter.hasNext()) continue;
                return false;
            } while ((nextDiagram = (Diagram)iter.next()).getType() == null || !nextDiagram.getType().equals("mappingTransformationDiagramType"));
            return true;
        }
        catch (ModelWorkspaceException e) {
            String message = UiConstants.Util.getString("TransformationDiagramUtil.getTransformationDiagramsError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)e, message);
        }
        return false;
    }
}

