/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.connection;

import java.util.Collections;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.diagram.ui.connection.AbstractNodeConnectionModel;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.mapping.ui.UiConstants;

public class EnumeratedTypeLink
extends AbstractNodeConnectionModel
implements UiConstants {
    private DiagramModelNode sourceNode;
    private DiagramModelNode targetNode;

    public EnumeratedTypeLink(DiagramModelNode theSource, DiagramModelNode theTarget) {
        this.setSourceNode(theSource);
        this.setTargetNode(theTarget);
    }

    public int getRouterStyle() {
        return 1;
    }

    public Object getSourceNode() {
        return this.sourceNode;
    }

    public Object getTargetNode() {
        return this.targetNode;
    }

    public List getToolTipStrings() {
        return Collections.singletonList(this.toString());
    }

    public void setSourceNode(Object theNode) {
        CoreArgCheck.isInstanceOf(DiagramModelNode.class, (Object)theNode);
        this.sourceNode = (DiagramModelNode)theNode;
    }

    public void setTargetNode(Object theNode) {
        CoreArgCheck.isInstanceOf(DiagramModelNode.class, (Object)theNode);
        this.targetNode = (DiagramModelNode)theNode;
    }

    public String toString() {
        String PREFIX = I18nUtil.getPropertyPrefix(EnumeratedTypeLink.class);
        String source = null;
        String target = null;
        if (this.sourceNode == null || this.targetNode == null) {
            source = this.sourceNode == null ? Util.getString(String.valueOf(PREFIX) + "undefined", new Object[0]) : this.sourceNode.getName();
            target = this.targetNode == null ? Util.getString(String.valueOf(PREFIX) + "undefined", new Object[0]) : this.targetNode.getName();
        } else {
            source = this.sourceNode.getName();
            target = this.targetNode.getName();
        }
        return Util.getString(String.valueOf(PREFIX) + "toString", new Object[]{source, target});
    }
}

