/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ShowDetailedMappingDiagramAction
extends MappingAction {
    public ShowDetailedMappingDiagramAction() {
        this.setUseWaitCursor(false);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_show_detailed_mapping.gif"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        Diagram transformationDiagram;
        ModelEditor editor;
        ModelResource modelResource;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null && this.wasMappingClassSelected(eObject) && (editor = ShowDetailedMappingDiagramAction.getModelEditorForObject((EObject)(transformationDiagram = this.getTransformationDiagram(modelResource, eObject)), true)) != null) {
            editor.openModelObject((Object)transformationDiagram);
        }
        this.determineEnablement();
    }

    private boolean wasMappingClassSelected(EObject eObject) {
        if (ModelUtilities.getModelResourceForModelObject((EObject)eObject) != null) {
            return eObject instanceof MappingClass && TransformationHelper.isVirtualSqlTable((Object)eObject);
        }
        return false;
    }

    private Diagram getTransformationDiagram(ModelResource modelResource, EObject eObject) {
        Iterator iter = null;
        String diagramType = null;
        diagramType = eObject instanceof StagingTable ? "transformationDiagramType" : "mappingTransformationDiagramType";
        try {
            iter = modelResource.getModelDiagrams().getDiagrams(eObject).iterator();
        }
        catch (ModelWorkspaceException e) {
            String message = UiConstants.Util.getString("ShowDetailedMappingDiagram.getDiagramsError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)e, message);
        }
        if (iter != null) {
            Diagram nextDiagram = null;
            while (iter.hasNext()) {
                nextDiagram = (Diagram)iter.next();
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals(diagramType)) continue;
                return nextDiagram;
            }
        }
        boolean requiresStart = false;
        boolean succeeded = false;
        try {
            requiresStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create Transformation Diagram", (Object)((Object)this));
            Diagram depDiagram = modelResource.getModelDiagrams().createNewDiagram(eObject, true);
            depDiagram.setType(diagramType);
            succeeded = true;
            Diagram diagram = depDiagram;
            return diagram;
        }
        catch (ModelWorkspaceException mwe) {
            String message = UiConstants.Util.getString("ShowDetailedMappingDiagram.createMappingDiagramError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)mwe, message);
        }
        finally {
            if (requiresStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return null;
    }

    private void determineEnablement() {
        ModelResource modelResource;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && this.wasMappingClassSelected(eObject) && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null && ModelUtilities.isVirtual((ModelResource)modelResource)) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    private static ModelEditor getModelEditorForObject(EObject object, boolean forceOpen) {
        ModelEditor result = null;
        IFile file = null;
        ModelResource mdlRsrc = ModelUtilities.getModelResourceForModelObject((EObject)object);
        if (mdlRsrc != null) {
            file = (IFile)mdlRsrc.getResource();
            result = ShowDetailedMappingDiagramAction.getModelEditorForFile(file, forceOpen);
        }
        return result;
    }

    private static ModelEditor getModelEditorForFile(IFile file, boolean forceOpen) {
        IWorkbenchPage page;
        ModelEditor result = null;
        if (file != null && (page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IEditorInput input;
                IEditorPart editor = editors[i].getEditor(false);
                if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                    if (!(editor instanceof ModelEditor)) break;
                    result = (ModelEditor)editor;
                    break;
                }
                ++i;
            }
            if (result == null && forceOpen) {
                try {
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    if (editor instanceof ModelEditor) {
                        result = (ModelEditor)editor;
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

