/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.IgnorableNotificationSource;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetUtil;

public class SetExcludeFromDocumentSpecialAction
extends SortableSelectionAction
implements IgnorableNotificationSource {
    private static String EXCLUDE_TITLE = UiConstants.Util.getString("SetIncludeExcludeAction.Exclude.title", new Object[0]);
    private static String EXCLUDE_TOOLTIP = UiConstants.Util.getString("SetIncludeExcludeAction.Exclude.tooltip", new Object[0]);
    boolean bDefaultExcludeState = true;
    protected int ALL_EXCLUDED = 0;
    protected int ALL_INCLUDED = 1;
    protected int BOTH_INCLUDED_AND_EXCLUDED = 2;

    public SetExcludeFromDocumentSpecialAction() {
        this.setText(EXCLUDE_TITLE);
        this.setToolTipText(EXCLUDE_TOOLTIP);
        this.setDefaultExcludeState(true);
    }

    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    protected boolean isValidSelection(ISelection selection) {
        boolean isValid = true;
        if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
            isValid = false;
        }
        if (isValid && SelectionUtilities.isAllEObjects((ISelection)selection)) {
            List eObjs = SelectionUtilities.getSelectedEObjects((ISelection)selection);
            isValid = this.isSelectionAppropriate(eObjs);
        } else {
            isValid = false;
        }
        return isValid;
    }

    public void run() {
        this.internalRun();
    }

    private void internalRun() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        List lstSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)SetExcludeFromDocumentSpecialAction.this.getSelection());
                        SetExcludeFromDocumentSpecialAction.this.setExcluded(lstSelectedEObjects, SetExcludeFromDocumentSpecialAction.this.bDefaultExcludeState);
                    }
                    catch (Exception e) {
                        DiagramController controller;
                        UiConstants.Util.log((Throwable)e);
                        WidgetUtil.showError((String)e.getLocalizedMessage());
                        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
                        if (de != null && (controller = de.getDiagramController()) != null && controller instanceof MappingDiagramController) {
                            ((MappingDiagramController)controller).refresh(true);
                        }
                    }
                }
                finally {
                    DiagramController controller;
                    DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
                    if (de != null && (controller = de.getDiagramController()) != null && controller instanceof MappingDiagramController) {
                        ((MappingDiagramController)controller).refresh(true);
                    }
                }
            }
        });
    }

    void setExcluded(List lstSelectedEObjects, boolean exclude) {
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Excluded Value", (Object)((Object)this));
        boolean succeeded = false;
        try {
            for (EObject eoTemp : lstSelectedEObjects) {
                XmlDocumentUtil.setExcluded((Object)eoTemp, (boolean)exclude);
            }
            succeeded = true;
        }
        finally {
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    protected boolean isSelectionAppropriate(List lstSelectedEObjects) {
        if (!this.allSelectedAreDocNodes(lstSelectedEObjects)) {
            return false;
        }
        int iSelectionType = this.getXmlDocNodeSelectionType(lstSelectedEObjects);
        return iSelectionType == this.ALL_INCLUDED || iSelectionType == this.BOTH_INCLUDED_AND_EXCLUDED;
    }

    private boolean allSelectedAreDocNodes(List selectedEObjects) {
        for (EObject eoTemp : selectedEObjects) {
            if (ModelMapperFactory.isXmlTreeNode((EObject)eoTemp) || TransformationHelper.isXmlDocument((Object)eoTemp)) continue;
            return false;
        }
        return true;
    }

    public int getXmlDocNodeSelectionType(List lstSelectedEObjects) {
        boolean bSomeAreExcluded = false;
        boolean bSomeAreIncluded = false;
        int iResultType = 0;
        for (EObject eoTemp : lstSelectedEObjects) {
            if (XmlDocumentUtil.isExcluded((Object)eoTemp, (boolean)false)) {
                bSomeAreExcluded = true;
                continue;
            }
            bSomeAreIncluded = true;
        }
        if (bSomeAreExcluded && bSomeAreIncluded) {
            iResultType = this.BOTH_INCLUDED_AND_EXCLUDED;
        } else if (bSomeAreExcluded) {
            iResultType = this.ALL_EXCLUDED;
        } else if (bSomeAreIncluded) {
            iResultType = this.ALL_INCLUDED;
        }
        return iResultType;
    }

    public void setDefaultExcludeState(boolean bDefaultExcludeState) {
        this.bDefaultExcludeState = bDefaultExcludeState;
    }
}

