/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;

public class NewMappingLinkAction
extends MappingAction {
    private static final String ACTION_DESCRIPTION = "New Mapping Link";

    public NewMappingLinkAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_new_mapping_link.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        List selectedObjects;
        if (this.getMappingClassFactory() != null && (selectedObjects = SelectionUtilities.getSelectedObjects((ISelection)this.getSelection())).size() == 2 && this.getMappingClassFactory() != null) {
            EObject eObject1 = (EObject)selectedObjects.get(0);
            EObject eObject2 = (EObject)selectedObjects.get(1);
            MappingClassColumn mcc = null;
            EObject locationEObject = null;
            if (this.isMappingClassColumn(eObject1)) {
                mcc = (MappingClassColumn)eObject1;
                locationEObject = eObject2;
            }
            if (mcc == null && this.isMappingClassColumn(eObject2)) {
                mcc = (MappingClassColumn)eObject2;
                locationEObject = eObject1;
            }
            if (mcc != null && locationEObject != null) {
                boolean canUndo = true;
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION, (Object)((Object)this));
                boolean succeeded = false;
                try {
                    this.getMappingClassFactory().addLocation(mcc, locationEObject);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
        this.setEnabled(false);
    }

    private void determineEnablement() {
        List selectedObjects;
        boolean enable = false;
        if (this.getPart() instanceof ModelEditor && SelectionUtilities.isMultiSelection((ISelection)this.getSelection()) && (selectedObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection())).size() == 2 && this.getMappingClassFactory() != null) {
            EObject eObject1 = (EObject)selectedObjects.get(0);
            EObject eObject2 = (EObject)selectedObjects.get(1);
            MappingClassColumn mcc = null;
            EObject locationEObject = null;
            if (this.isMappingClassColumn(eObject1)) {
                mcc = (MappingClassColumn)eObject1;
                locationEObject = eObject2;
            }
            if (mcc == null && this.isMappingClassColumn(eObject2)) {
                mcc = (MappingClassColumn)eObject2;
                locationEObject = eObject1;
            }
            if (mcc != null && locationEObject != null && this.isWritable()) {
                enable = this.getMappingClassFactory().canAddLocation(mcc, locationEObject);
            }
        }
        this.setEnabled(enable);
    }
}

