/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.mapping.ui.PluginConstants;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.util.MappingNotificationListener;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.PreferenceKeyAndDefaultValue;
import org.teiid.designer.ui.common.actions.ActionService;

public class UiPlugin
extends AbstractUiPlugin
implements UiConstants {
    private static UiPlugin plugin;
    private MappingNotificationListener notificationListener = new MappingNotificationListener();

    public UiPlugin() {
        plugin = this;
        this.init();
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    private void init() {
        try {
            ModelerCore.getModelContainer().getChangeNotifier().addListener((INotifyChangedListener)this.notificationListener);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        this.storeDefaultPreferenceValues();
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        return null;
    }

    public ActionService getActionService(IWorkbenchPage page) {
        return DiagramUiPlugin.getDefault().getActionService(page);
    }

    public PluginUtil getPluginUtil() {
        return Util;
    }

    public void stop(BundleContext context) throws Exception {
        ModelerCore.getModelContainer().getChangeNotifier().removeListener((INotifyChangedListener)this.notificationListener);
        super.stop(context);
    }

    private void storeDefaultPreferenceValues() {
        IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < PluginConstants.Prefs.Appearance.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Appearance.PREFERENCES[i]);
            ++i;
        }
        i = 0;
        while (i < PluginConstants.Prefs.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.PREFERENCES[i]);
            ++i;
        }
        DiagramUiPlugin.getDefault().savePreferences();
    }

    public IPreferenceStore getPreferenceStore() {
        return DiagramUiPlugin.getDefault().getPreferenceStore();
    }
}

