/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.processor;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.modelgenerator.processor.DatatypeFinder;

public class BuiltInDatatypeFinder
implements DatatypeFinder {
    public static final BuiltInDatatypeFinder INSTANCE = new BuiltInDatatypeFinder();

    @Override
    public EObject findDatatype(String name) throws CoreException {
        DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
        if (name == null) {
            return dtMgr.getAnySimpleType();
        }
        EObject datatype = dtMgr.getBuiltInDatatype(name);
        return datatype;
    }

    @Override
    public EObject findDatatype(URI uri) throws CoreException {
        DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
        if (uri == null) {
            return dtMgr.getAnySimpleType();
        }
        EObject datatype = dtMgr.findDatatype(uri.toString());
        return datatype;
    }

    @Override
    public List findAllDatatypes(String name) throws CoreException {
        EObject datatype = this.findDatatype(name);
        if (datatype != null) {
            LinkedList<EObject> result = new LinkedList<EObject>();
            result.add(datatype);
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List findAllDatatypes(URI uri) throws CoreException {
        EObject datatype = this.findDatatype(uri);
        if (datatype != null) {
            LinkedList<EObject> result = new LinkedList<EObject>();
            result.add(datatype);
            return result;
        }
        return Collections.EMPTY_LIST;
    }
}

