/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.io.Serializable;
import org.mockito.exceptions.Reporter;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ReturnsArgumentAt
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = -589315085166295101L;
    public static final int LAST_ARGUMENT = -1;
    private final int wantedArgumentPosition;

    public ReturnsArgumentAt(int wantedArgumentPosition) {
        this.wantedArgumentPosition = this.checkWithinAllowedRange(wantedArgumentPosition);
    }

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        this.validateIndexWithinInvocationRange(invocation);
        return invocation.getArguments()[this.actualArgumentPosition(invocation)];
    }

    private int actualArgumentPosition(InvocationOnMock invocation) {
        return this.returningLastArg() ? this.lastArgumentIndexOf(invocation) : this.argumentIndexOf(invocation);
    }

    private boolean returningLastArg() {
        return this.wantedArgumentPosition == -1;
    }

    private int argumentIndexOf(InvocationOnMock invocation) {
        return this.wantedArgumentPosition;
    }

    private int lastArgumentIndexOf(InvocationOnMock invocation) {
        return invocation.getArguments().length - 1;
    }

    private int checkWithinAllowedRange(int argumentPosition) {
        if (argumentPosition != -1 && argumentPosition < 0) {
            new Reporter().invalidArgumentRangeAtIdentityAnswerCreationTime();
        }
        return argumentPosition;
    }

    public int wantedArgumentPosition() {
        return this.wantedArgumentPosition;
    }

    public void validateIndexWithinInvocationRange(InvocationOnMock invocation) {
        if (!this.argumentPositionInRange(invocation)) {
            new Reporter().invalidArgumentPositionRangeAtInvocationTime(invocation, this.returningLastArg(), this.wantedArgumentPosition);
        }
    }

    private boolean argumentPositionInRange(InvocationOnMock invocation) {
        int actualArgumentPosition = this.actualArgumentPosition(invocation);
        if (actualArgumentPosition < 0) {
            return false;
        }
        if (!invocation.getMethod().isVarArgs()) {
            return invocation.getArguments().length > actualArgumentPosition;
        }
        return true;
    }

    public Class returnedTypeOnSignature(InvocationOnMock invocation) {
        int actualArgumentPosition = this.actualArgumentPosition(invocation);
        if (!invocation.getMethod().isVarArgs()) {
            return invocation.getMethod().getParameterTypes()[actualArgumentPosition];
        }
        Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
        int varargPosition = parameterTypes.length - 1;
        if (actualArgumentPosition < varargPosition) {
            return parameterTypes[actualArgumentPosition];
        }
        return parameterTypes[varargPosition].getComponentType();
    }
}

