/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.lang.reflect.Array;

public class Equality {
    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null;
        }
        if (Equality.isArray(o1)) {
            return Equality.isArray(o2) && Equality.areArraysEqual(o1, o2);
        }
        return o1.equals(o2);
    }

    static boolean areArraysEqual(Object o1, Object o2) {
        return Equality.areArrayLengthsEqual(o1, o2) && Equality.areArrayElementsEqual(o1, o2);
    }

    static boolean areArrayLengthsEqual(Object o1, Object o2) {
        return Array.getLength(o1) == Array.getLength(o2);
    }

    static boolean areArrayElementsEqual(Object o1, Object o2) {
        int i = 0;
        while (i < Array.getLength(o1)) {
            if (!Equality.areEqual(Array.get(o1, i), Array.get(o2, i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isArray(Object o) {
        return o.getClass().isArray();
    }
}

