/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.debugging.FindingsListener;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.invocation.Invocation;

public class WarningsFinder {
    private final List<Invocation> baseUnusedStubs;
    private final List<InvocationMatcher> baseAllInvocations;

    public WarningsFinder(List<Invocation> unusedStubs, List<InvocationMatcher> allInvocations) {
        this.baseUnusedStubs = unusedStubs;
        this.baseAllInvocations = allInvocations;
    }

    public void find(FindingsListener findingsListener) {
        LinkedList<Invocation> unusedStubs = new LinkedList<Invocation>(this.baseUnusedStubs);
        LinkedList<InvocationMatcher> allInvocations = new LinkedList<InvocationMatcher>(this.baseAllInvocations);
        Iterator unusedIterator = unusedStubs.iterator();
        while (unusedIterator.hasNext()) {
            Invocation invocation = (Invocation)unusedIterator.next();
            Iterator unstubbedIterator = allInvocations.iterator();
            while (unstubbedIterator.hasNext()) {
                InvocationMatcher unstubbed = (InvocationMatcher)unstubbedIterator.next();
                if (!unstubbed.hasSimilarMethod(invocation)) continue;
                findingsListener.foundStubCalledWithDifferentArgs(invocation, unstubbed);
                unusedIterator.remove();
                unstubbedIterator.remove();
            }
        }
        for (Invocation invocation : unusedStubs) {
            findingsListener.foundUnusedStub(invocation);
        }
        for (InvocationMatcher invocationMatcher : allInvocations) {
            findingsListener.foundUnstubbed(invocationMatcher);
        }
    }
}

