/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcTableType;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcTableImpl;

public class JdbcTableTypeImpl
extends JdbcNodeImpl
implements JdbcTableType {
    static final String SQL_SERVER_DB_METADATA = "SQLServerDatabaseMetaData";

    public JdbcTableTypeImpl(JdbcNode parent, String typeName) {
        super(107, typeName, parent);
    }

    @Override
    protected JdbcNode[] computeChildren() throws JdbcException {
        ArrayList<JdbcTableImpl> children;
        block16: {
            DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
            children = new ArrayList<JdbcTableImpl>();
            String schemaName = JdbcTableTypeImpl.getSchemaName(this);
            String catalogName = JdbcTableTypeImpl.getCatalogName(this);
            boolean isSqlServer = metadata.getClass().getName().endsWith(SQL_SERVER_DB_METADATA);
            ResultSet resultSet = null;
            try {
                try {
                    String[] tableTypes = new String[]{this.getName()};
                    resultSet = metadata.getTables(catalogName, schemaName, "%", tableTypes);
                    while (resultSet != null && resultSet.next()) {
                        String tableName = resultSet.getString(3);
                        String remarks = resultSet.getString(5);
                        JdbcTableImpl table = new JdbcTableImpl(this, tableName);
                        table.setRemarks(remarks);
                        children.add(table);
                    }
                }
                catch (Throwable t) {
                    if (!isSqlServer) {
                        Object[] params = new Object[]{metadata.getClass().getName(), this.getJdbcDatabase()};
                        String msg = JdbcPlugin.Util.getString("JdbcTableTypeImpl.Unexpected_exception_while_calling_getTables()_and_processing_results", params);
                        JdbcPlugin.Util.log(2, t, msg);
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            JdbcPlugin.Util.log((Throwable)e);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                }
                throw throwable;
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
            }
        }
        return children.toArray(new JdbcNode[children.size()]);
    }

    @Override
    public String getTypeName() {
        return JdbcPlugin.Util.getString("JdbcTableTypeImpl.TableTypeName", new Object[0]);
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getParent().getFullyQualifiedName();
    }

    @Override
    public IPath getPathInSource() {
        return null;
    }

    @Override
    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    @Override
    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    @Override
    public boolean isDatabaseObject() {
        return false;
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }
}

