/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.SQLException;
import java.text.StringCharacterIterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.IPathComparator;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.data.Request;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcNodeVisitor;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.impl.InternalJdbcDatabase;
import org.teiid.designer.jdbc.metadata.impl.InternalJdbcNode;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeCache;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeSelections;
import org.teiid.designer.jdbc.metadata.impl.RequestContainer;

public abstract class JdbcNodeImpl
implements JdbcNode,
Comparable,
InternalJdbcNode {
    public static final String EXCLUDED_PATTERN = null;
    public static final String WILDCARD_PATTERN = "%";
    public static final String NOT_APPLICABLE = "";
    public static final String DEFAULT_QUALIFIED_NAME_DELIMITER = ".";
    private static final JdbcNode[] EMPTY_CHILDREN_ARRAY = new JdbcNodeImpl[0];
    private IPath path;
    private final int type;
    private final String name;
    private final JdbcNode parent;
    private JdbcNode[] children;
    private Object childrenLock = new Object();
    private RequestContainer requests;
    private int selectionMode;
    private String qualifiedNameDelimiter;

    protected JdbcNodeImpl(int type, String name, JdbcNode parent) {
        this.type = type;
        if (name == null) {
            this.name = NOT_APPLICABLE;
        } else {
            name = name.substring(name.lastIndexOf(47) + 1);
            this.name = name = name.substring(name.lastIndexOf(92) + 1);
        }
        this.parent = parent;
        this.children = null;
        this.path = this.parent == null ? Path.ROOT : this.parent.getPath().append(this.getName());
        this.selectionMode = this.getDefaultSelectionMode();
        if (parent != null) {
            int parentSelectionMode = parent.getSelectionMode();
            if (parentSelectionMode == 1) {
                this.doSetSelectionMode(1);
            } else if (parentSelectionMode == 0) {
                this.doSetSelectionMode(0);
            } else {
                JdbcNodeSelections selections = ((InternalJdbcDatabase)((Object)this.getJdbcDatabase())).getJdbcNodeSelections();
                int mode = selections.getSelectionMode(this.path);
                if (mode == 1) {
                    this.selectionMode = 1;
                } else if (mode == 0) {
                    this.selectionMode = 0;
                } else if (mode == 2) {
                    this.selectionMode = 2;
                }
            }
        }
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public abstract IPath getPathInSource();

    @Override
    public boolean isDatabaseObject() {
        return true;
    }

    @Override
    public abstract JdbcNode getParentDatabaseObject(boolean var1, boolean var2);

    @Override
    public JdbcNode findChild(String name) {
        JdbcDatabase dbNode = this.getJdbcDatabase();
        CoreArgCheck.isNotNull((Object)dbNode);
        return dbNode.findJdbcNode(this.getPath().append(name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JdbcNode getParent() {
        return this.parent;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JdbcNode[] getChildren() throws JdbcException {
        if (this.children == null) {
            Object object = this.childrenLock;
            synchronized (object) {
                if (this.children == null) {
                    this.children = this.computeChildren();
                    if (this.children == null) {
                        this.children = EMPTY_CHILDREN_ARRAY;
                    } else {
                        InternalJdbcDatabase dbNode = (InternalJdbcDatabase)((Object)this.getJdbcDatabase());
                        JdbcNodeCache cache = dbNode.getJdbcNodeCache();
                        int i = 0;
                        while (i < this.children.length) {
                            cache.put(this.children[i]);
                            ++i;
                        }
                    }
                }
            }
        }
        return this.children;
    }

    public void addChild(JdbcNode node) throws JdbcException {
        JdbcNode[] currentChildren = this.getChildren();
        int currentNumChildren = currentChildren.length;
        if (currentNumChildren != 0) {
            JdbcNode[] newChildren = new JdbcNode[currentNumChildren + 1];
            System.arraycopy(currentChildren, 0, newChildren, 0, currentNumChildren);
            newChildren[currentNumChildren] = node;
            this.children = newChildren;
        } else {
            this.children = new JdbcNode[]{node};
        }
        InternalJdbcDatabase dbNode = (InternalJdbcDatabase)((Object)this.getJdbcDatabase());
        dbNode.getJdbcNodeCache().put(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.children != null) {
            Object object = this.childrenLock;
            synchronized (object) {
                InternalJdbcDatabase dbNode = (InternalJdbcDatabase)((Object)this.getJdbcDatabase());
                JdbcNodeCache cache = dbNode.getJdbcNodeCache();
                int i = 0;
                while (i < this.children.length) {
                    JdbcNode child = this.children[i];
                    cache.remove(child);
                    child.refresh();
                    ++i;
                }
                this.children = null;
            }
        }
    }

    protected abstract JdbcNode[] computeChildren() throws JdbcException;

    public String toString() {
        String typeName = this.getTypeName();
        return String.valueOf(typeName == null ? NOT_APPLICABLE : typeName) + this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JdbcNodeImpl) {
            JdbcNodeImpl that = (JdbcNodeImpl)obj;
            if (this.type != that.type) {
                return false;
            }
            if (this.parent != that.parent) {
                return false;
            }
            if (this.name != null ? !this.name.equalsIgnoreCase(that.name) : that.name != null) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = HashCodeUtil.hashCode((int)hash, (int)this.type);
        hash = HashCodeUtil.hashCode((int)hash, (Object[])new Object[]{this.parent});
        hash = HashCodeUtil.hashCode((int)hash, (Object[])new Object[]{this.name});
        return hash;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        JdbcNodeImpl that = (JdbcNodeImpl)obj;
        CoreArgCheck.isNotNull((Object)obj);
        int diffType = this.type - that.type;
        if (diffType != 0) {
            return diffType;
        }
        IPathComparator comparator = new IPathComparator();
        return comparator.compare(this.path, that.path);
    }

    @Override
    public void accept(JdbcNodeVisitor visitor, int depth) throws JdbcException {
        CoreArgCheck.isNotNull((Object)visitor);
        CoreArgCheck.isTrue((depth == 2 || depth == 1 || depth == 0 ? 1 : 0) != 0, (String)JdbcPlugin.Util.getString("JdbcNodeImpl.InvalidDepthValue", new Object[0]));
        if (!visitor.visit(this) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        JdbcNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].accept(visitor, nextDepth);
            ++i;
        }
    }

    public static String getCatalogName(JdbcNode node) {
        JdbcDatabase dbNode = node.getJdbcDatabase();
        JdbcNode ancestor = node.getParent();
        while (ancestor != null && ancestor != dbNode) {
            if (ancestor instanceof JdbcCatalog) {
                return ancestor.getName();
            }
            ancestor = ancestor.getParent();
        }
        return EXCLUDED_PATTERN;
    }

    public static String getSchemaName(JdbcNode node) {
        JdbcDatabase dbNode = node.getJdbcDatabase();
        JdbcNode ancestor = node.getParent();
        while (ancestor != null && ancestor != dbNode) {
            if (ancestor instanceof JdbcSchema) {
                return ancestor.getName();
            }
            ancestor = ancestor.getParent();
        }
        return EXCLUDED_PATTERN;
    }

    public static String getCatalogPattern(JdbcNode node) {
        String catalogNamePattern = JdbcNodeImpl.getCatalogName(node);
        if (NOT_APPLICABLE.equals(catalogNamePattern)) {
            boolean catalogsSupported = false;
            try {
                catalogsSupported = node.getJdbcDatabase().getCapabilities().supportsCatalogsInDataManipulation();
            }
            catch (JdbcException e) {
                JdbcPlugin.Util.log((Throwable)((Object)e));
            }
            catch (SQLException sQLException) {}
            if (!catalogsSupported) {
                catalogNamePattern = EXCLUDED_PATTERN;
            }
        }
        return catalogNamePattern;
    }

    public static String getSchemaPattern(JdbcNode node) {
        String schemaNamePattern = JdbcNodeImpl.getSchemaName(node);
        if (NOT_APPLICABLE.equals(schemaNamePattern)) {
            boolean schemaSupported = false;
            try {
                schemaSupported = node.getJdbcDatabase().getCapabilities().supportsCatalogsInDataManipulation();
            }
            catch (JdbcException e) {
                JdbcPlugin.Util.log((Throwable)((Object)e));
            }
            catch (SQLException sQLException) {}
            if (!schemaSupported) {
                schemaNamePattern = EXCLUDED_PATTERN;
            }
        }
        return schemaNamePattern;
    }

    @Override
    public String[] getNamesOfResults() {
        return this.getRequestContainer().getNamesOfResults();
    }

    @Override
    public Request getRequest(String name) {
        return this.getRequestContainer().getRequest(name);
    }

    @Override
    public Request getRequest(String name, boolean includeMetadata) {
        return this.getRequestContainer().getRequest(name, includeMetadata);
    }

    protected synchronized RequestContainer getRequestContainer() {
        if (this.requests == null) {
            this.requests = new RequestContainer(this.createRequests());
        }
        return this.requests;
    }

    protected Request[] createRequests() {
        return new Request[0];
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelected(boolean selected) {
        int newMode;
        int n = newMode = selected ? 1 : 0;
        if (this.selectionMode == newMode) {
            return;
        }
        this.doSetSelectionMode(newMode);
        if (this.children != null) {
            JdbcNode[] childrenCopy = null;
            Object object = this.childrenLock;
            synchronized (object) {
                int numChildren = this.children.length;
                childrenCopy = new JdbcNode[numChildren];
                System.arraycopy(this.children, 0, childrenCopy, 0, numChildren);
            }
            if (this.selectionMode == 0) {
                int i = 0;
                while (i < childrenCopy.length) {
                    JdbcNode child = childrenCopy[i];
                    child.setSelected(false);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < childrenCopy.length) {
                    JdbcNode child = childrenCopy[i];
                    child.setSelected(true);
                    ++i;
                }
            }
        }
        if (this.parent != null && this.parent instanceof InternalJdbcNode) {
            ((InternalJdbcNode)((Object)this.parent)).checkSelectionMode(this);
        }
    }

    protected int getDefaultSelectionMode() {
        return 0;
    }

    protected void doSetSelectionMode(int mode) {
        this.selectionMode = mode;
        InternalJdbcDatabase db = (InternalJdbcDatabase)((Object)this.getJdbcDatabase());
        JdbcNodeSelections selections = db.getJdbcNodeSelections();
        selections.setSelected(this.getPath(), this.selectionMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkSelectionMode(JdbcNode childNodeWithChangedSelection) {
        if (this.selectionMode == childNodeWithChangedSelection.getSelectionMode()) {
            return;
        }
        if (this.children == null) {
            return;
        }
        JdbcNode[] childrenCopy = null;
        Object object = this.childrenLock;
        synchronized (object) {
            int numChildren = this.children.length;
            childrenCopy = new JdbcNode[numChildren];
            System.arraycopy(this.children, 0, childrenCopy, 0, numChildren);
        }
        int previousMode = this.selectionMode;
        boolean hasUnselected = false;
        boolean hasSelected = false;
        boolean hasPartiallySelected = false;
        int i = 0;
        while (i < childrenCopy.length) {
            JdbcNode child = childrenCopy[i];
            int childMode = child.getSelectionMode();
            if (!hasSelected && childMode == 1) {
                hasSelected = true;
            }
            if (!hasUnselected && childMode == 0) {
                hasUnselected = true;
            }
            if (!hasPartiallySelected && childMode == 2) {
                hasPartiallySelected = true;
            }
            if (hasPartiallySelected || hasSelected && hasUnselected) {
                hasPartiallySelected = true;
                this.doSetSelectionMode(2);
                break;
            }
            ++i;
        }
        if (!hasPartiallySelected) {
            if (hasSelected) {
                this.doSetSelectionMode(1);
            }
            if (hasUnselected) {
                this.doSetSelectionMode(0);
            }
        }
        if (this.selectionMode != previousMode && this.parent != null && this.parent instanceof InternalJdbcNode) {
            ((InternalJdbcNode)((Object)this.parent)).checkSelectionMode(this);
        }
    }

    @Override
    public String getUnqualifiedName() {
        return this.getUnqualifiedName(this.getName());
    }

    @Override
    public String getUnqualifiedName(String originalName) {
        String quoteString = null;
        try {
            quoteString = this.getJdbcDatabase().getCapabilities().getIdentifierQuoteString();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        catch (SQLException sQLException) {}
        if (quoteString == null || quoteString.trim().length() == 0) {
            return originalName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(quoteString);
        sb.append(originalName);
        sb.append(quoteString);
        return sb.toString();
    }

    protected boolean containsCharacters(String name, String extraChars) {
        int numChars = extraChars.length();
        int i = 0;
        while (i < numChars) {
            char extraChar = extraChars.charAt(i);
            if (name.indexOf(extraChar) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getQualifedNameDelimiter() {
        if (this.qualifiedNameDelimiter == null) {
            try {
                this.qualifiedNameDelimiter = this.getJdbcDatabase().getCapabilities().getCatalogSeparator();
                if (this.qualifiedNameDelimiter != null && this.qualifiedNameDelimiter.trim().length() == 0) {
                    this.qualifiedNameDelimiter = null;
                }
            }
            catch (JdbcException e) {
                JdbcPlugin.Util.log((Throwable)((Object)e));
            }
            catch (SQLException sQLException) {}
            if (this.qualifiedNameDelimiter == null) {
                this.qualifiedNameDelimiter = DEFAULT_QUALIFIED_NAME_DELIMITER;
            }
        }
        return this.qualifiedNameDelimiter;
    }

    public boolean isValidName(String name) {
        CoreArgCheck.isNotNull((Object)name);
        boolean isValid = false;
        StringCharacterIterator charIter = new StringCharacterIterator(name);
        char c = charIter.first();
        if (c != '\uffff' && Character.isLetter(c)) {
            isValid = true;
        }
        return isValid;
    }
}

