/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.data.JdbcConversionException;
import org.teiid.designer.jdbc.data.Response;
import org.teiid.designer.jdbc.data.Results;
import org.teiid.designer.jdbc.data.ResultsMetadata;

public class ResultsImpl
implements Results {
    private final Response response;
    private final List rowList;
    private Object[] rowArray;
    private Results next;
    private Results previous;

    public ResultsImpl(Response response) {
        this(response, response.getRecords());
    }

    public ResultsImpl(Response response, List sublist) {
        this.response = response;
        this.rowList = sublist;
    }

    @Override
    public ResultsMetadata getMetadata() {
        return this.response.getMetadata();
    }

    @Override
    public int getRowCount() {
        return this.rowList.size();
    }

    @Override
    public int getTotalRowCount() {
        return this.response.getRecords().size();
    }

    @Override
    public Object[] getRows() {
        if (this.rowArray == null) {
            this.rowArray = this.rowList.toArray();
        }
        return this.rowArray;
    }

    @Override
    public Object getObject(Object row, int columnIndex) {
        CoreArgCheck.isNotNull((Object)row);
        List record = (List)row;
        if (columnIndex >= record.size()) {
            return null;
        }
        return record.get(columnIndex);
    }

    @Override
    public String getString(Object row, int columnIndex) {
        Object value = this.getObject(row, columnIndex);
        return value == null ? null : value.toString();
    }

    @Override
    public boolean getBoolean(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_boolean", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public short getShort(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Long) {
            return ((Long)value).shortValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).shortValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_short", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_short", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public int getInt(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_int", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_int", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public long getLong(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_long", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_long", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public float getFloat(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_float", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_float", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public double getDouble(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_double", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_double", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public byte getByte(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).byteValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).byteValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_byte", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_byte", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public byte[] getBytes(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).toByteArray();
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_byte_array", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public Date getDate(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            long longvalue = ((java.util.Date)value).getTime();
            return new Date(longvalue);
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            return new Date(longValue);
        }
        if (value instanceof BigDecimal) {
            long longValue = ((BigDecimal)value).longValue();
            return new Date(longValue);
        }
        if (value instanceof BigInteger) {
            long longValue = ((BigInteger)value).longValue();
            return new Date(longValue);
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_Date", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public Timestamp getTimestamp(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            long longvalue = ((java.util.Date)value).getTime();
            return new Timestamp(longvalue);
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            return new Timestamp(longValue);
        }
        if (value instanceof BigDecimal) {
            long longValue = ((BigDecimal)value).longValue();
            return new Timestamp(longValue);
        }
        if (value instanceof BigInteger) {
            long longValue = ((BigInteger)value).longValue();
            return new Timestamp(longValue);
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_Timestamp", params);
        throw new JdbcConversionException(msg);
    }

    @Override
    public void setObject(Object row, int columnIndex, Object newValue) {
        if (row == null) {
            return;
        }
        List record = (List)row;
        record.set(columnIndex, newValue);
    }

    @Override
    public boolean hasNextResults() {
        return this.next != null;
    }

    @Override
    public Results getNextResults() {
        return this.next;
    }

    @Override
    public boolean hasPreviousResults() {
        return this.previous != null;
    }

    @Override
    public Results getPreviousResults() {
        return this.previous;
    }

    public void setPrevious(Results prev) {
        this.previous = prev;
    }

    public void setNext(Results next) {
        this.next = next;
    }
}

