/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.utiltests;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.resolvers.ConfigNameResolver;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConfigNameResolverTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getAllJBossServerTypeParameters());
    }

    public ConfigNameResolverTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() throws CoreException {
        this.server = ServerCreationTestUtils.createServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    private static boolean isJBoss7Style(IServer server) {
        ServerExtendedProperties sep = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)server);
        boolean as7Style = sep.getFileStructure() == 2;
        return as7Style;
    }

    @Test
    public void testConfigNameResolver() {
        String[] vars = ConfigNameResolver.ALL_VARIABLES;
        int i = 0;
        while (i < vars.length) {
            String var = ConfigNameResolver.getVariablePattern((String)vars[i]);
            String result = new ConfigNameResolver().performSubstitutions(var, this.server.getName());
            IJBossServer jbs = ServerConverter.getJBossServer((IServer)this.server);
            if (jbs == null) {
                ConfigNameResolverTest.assertEquals((String)"", (String)result);
            } else if (vars[i].equals("jboss_config")) {
                this.testConfig(var, result, ConfigNameResolverTest.isJBoss7Style(this.server));
            } else if (vars[i].equals("jboss_config_dir")) {
                this.testConfigDir(var, result, ConfigNameResolverTest.isJBoss7Style(this.server));
            } else if (vars[i].equals("jboss_config_file")) {
                this.testAS7ConfigFile(var, result, ConfigNameResolverTest.isJBoss7Style(this.server));
            } else if (vars[i].equals("jboss_server_home")) {
                this.testServerHome(var, result, jbs.getServer().getRuntime());
            } else {
                ConfigNameResolverTest.fail((String)("Variable " + vars[i] + " not tested"));
            }
            ++i;
        }
    }

    private void testConfig(String var, String result, boolean isAS7) {
        if (!isAS7) {
            ConfigNameResolverTest.assertEquals((String)result, (String)"default");
        } else {
            ConfigNameResolverTest.assertEquals((String)result, (String)"");
        }
    }

    private void testConfigDir(String var, String result, boolean isAS7) {
        if (!isAS7) {
            ConfigNameResolverTest.assertNotSame((Object)result, (Object)var);
            ConfigNameResolverTest.assertNotSame((Object)result, (Object)"");
        } else {
            ConfigNameResolverTest.assertEquals((String)result, (String)this.server.getRuntime().getLocation().append("standalone").append("configuration").toString());
        }
    }

    private void testServerHome(String var, String result, IRuntime rt) {
        ConfigNameResolverTest.assertNotNull((Object)rt);
        ConfigNameResolverTest.assertEquals((String)result, (String)rt.getLocation().toOSString());
    }

    private void testAS7ConfigFile(String var, String result, boolean isAS7) {
        if (isAS7) {
            ConfigNameResolverTest.assertEquals((String)result, (String)"standalone.xml");
        } else {
            ConfigNameResolverTest.assertEquals((String)result, (String)"");
        }
    }
}

