/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils.wtp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class TaskViewUtility {
    public static IResource getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static void verifyNoNewTasks(HashSet hashSet) {
        TaskViewUtility.verifyNoNewTasks(null, hashSet);
    }

    public static void verifyNoNewTasks(IResource resource, HashSet hashSet) {
        TaskViewUtility.verifyNoNewTasksImpl(resource, hashSet, true);
    }

    private static void verifyNoNewTasksImpl(IResource resource, HashSet hashSet, boolean failOnFailure) {
        IResource markerSource = resource == null ? TaskViewUtility.getWorkspaceRoot() : resource;
        IMarker[] markers = null;
        try {
            markers = markerSource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            Assert.fail();
        }
        int j = 0;
        while (markers != null && j < markers.length) {
            String failMsg;
            String message = markers[j].toString();
            try {
                message = (String)markers[j].getAttribute("message");
            }
            catch (Exception exception) {}
            if (hashSet == null) {
                failMsg = "Task in Tasks List: " + message;
                if (failOnFailure) {
                    Assert.fail((String)failMsg);
                } else {
                    System.out.println(failMsg);
                }
            } else if (!hashSet.contains(markers[j])) {
                failMsg = "New Task in Tasks List: " + message;
                if (failOnFailure) {
                    Assert.fail((String)failMsg);
                } else {
                    System.out.println(failMsg);
                }
            }
            ++j;
        }
    }

    public static void verifyNoErrors() {
        TaskViewUtility.verifyNoErrors(null);
    }

    public static void verifyNoErrors(IResource resource) {
        List markers = TaskViewUtility.getErrors(resource);
        if (markers != null && markers.size() > 0) {
            int size = markers.size();
            String message = size + " errors in tasks view:";
            int i = 0;
            while (i < size) {
                IMarker marker = (IMarker)markers.get(i);
                try {
                    message = String.valueOf(message) + "\n" + i + " " + (String)marker.getAttribute("message");
                }
                catch (Exception exception) {}
                ++i;
            }
            Assert.fail((String)message);
        }
    }

    public static List getErrors(IResource resource) {
        IResource markerSource = resource == null ? TaskViewUtility.getWorkspaceRoot() : resource;
        List markers = null;
        try {
            markers = TaskViewUtility.findSeverityMarkers(markerSource, 2);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return markers;
    }

    private static List findSeverityMarkers(IResource markerSource, int severityLevel) throws CoreException {
        IMarker[] markers = markerSource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        ArrayList<IMarker> results = null;
        int i = 0;
        while (i < markers.length) {
            Integer severity = (Integer)markers[i].getAttribute("severity");
            if (severity == severityLevel) {
                if (results == null) {
                    results = new ArrayList<IMarker>();
                }
                results.add(markers[i]);
            }
            ++i;
        }
        if (results == null) {
            results = Collections.EMPTY_LIST;
        }
        return results;
    }

    public static void verifyNoWarnings() {
    }

    public static void verifyNoTasks() {
        TaskViewUtility.verifyNoTasks(null);
    }

    public static void verifyNoTasks(IResource resource) {
        TaskViewUtility.verifyNoNewTasksImpl(resource, null, true);
    }

    public static void verifyNoTasks(boolean failOnFailure) {
        TaskViewUtility.verifyNoTasks(null, failOnFailure);
    }

    public static void verifyNoTasks(IResource resource, boolean failOnFailure) {
        TaskViewUtility.verifyNoNewTasksImpl(resource, null, failOnFailure);
    }

    public static void verifyErrors(List markerDescriptionsExpected) {
        TaskViewUtility.verifyErrors(markerDescriptionsExpected, true, false);
    }

    public static void verifyErrors(List markerDescriptionsExpected, boolean reportIfExpectedErrorNotFound, boolean removeAllSameTypesOfError) {
        ArrayList<Object> markerDescriptionsFound = null;
        try {
            List markersFound = TaskViewUtility.findSeverityMarkers(TaskViewUtility.getWorkspaceRoot(), 2);
            markerDescriptionsFound = new ArrayList<Object>(markersFound.size());
            int i = 0;
            while (i < markersFound.size()) {
                markerDescriptionsFound.add(((IMarker)markersFound.get(i)).getAttribute("message"));
                ++i;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            Assert.fail();
        }
        ArrayList<String> markerDescriptionsNotFound = new ArrayList<String>();
        ArrayList markersDescriptionsToRemove = new ArrayList();
        int i = 0;
        while (i < markerDescriptionsExpected.size()) {
            String messageToFind = (String)markerDescriptionsExpected.get(i);
            boolean found = false;
            int j = 0;
            while (j < markerDescriptionsFound.size() && (!found || removeAllSameTypesOfError)) {
                if (messageToFind.equals(markerDescriptionsFound.get(j))) {
                    found = true;
                    markersDescriptionsToRemove.add(markerDescriptionsFound.get(j));
                }
                ++j;
            }
            if (!found) {
                markerDescriptionsNotFound.add(messageToFind);
            }
            ++i;
        }
        markerDescriptionsFound.removeAll(markersDescriptionsToRemove);
        if (markerDescriptionsNotFound.size() > 0 || markerDescriptionsFound.size() > 0) {
            String messages = "";
            if (reportIfExpectedErrorNotFound) {
                int i2 = 0;
                while (i2 < markerDescriptionsNotFound.size()) {
                    messages = String.valueOf(messages) + "\nError not found:\"" + markerDescriptionsNotFound.get(i2) + "\"";
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < markerDescriptionsFound.size()) {
                messages = String.valueOf(messages) + "\nUnexpected error found:\"" + markerDescriptionsFound.get(i3) + "\"";
                ++i3;
            }
            if (!messages.equals("")) {
                Assert.fail((String)messages);
            }
        }
    }
}

