/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.view.logs.actions;

import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.fabric8.core.dto.LogEventDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.view.logs.LogsView;

public class OpenStackTraceAction
extends ActionSupport {
    private LogsView view;
    private JavaStackTraceConsole console;

    public OpenStackTraceAction(LogsView view, String text) {
        super(text, FabricPlugin.getDefault().getImageDescriptor("stckframe_obj.gif"));
        this.view = view;
        this.initConsole();
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        LogEventDTO event = this.view.getSelectedEvent();
        if (event == null) {
            return;
        }
        boolean stillRegistered = this.checkRegistration();
        if (!stillRegistered) {
            this.registerConsole();
        }
        this.console.clearConsole();
        this.console.getDocument().set(event.toString());
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
    }

    private boolean checkRegistration() {
        IConsole[] consoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoleArray.length) {
            IConsole c = consoleArray[i];
            if (c == this.console) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void registerConsole() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }

    private void initConsole() {
        this.console = new JavaStackTraceConsole();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }
}

