/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.properties;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.ui.ICanValidate;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.ui.Widgets;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.commons.ui.form.FormSupport;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.ui.Messages;
import org.fusesource.ide.fabric8.ui.navigator.properties.ListEditor;
import org.fusesource.ide.fabric8.ui.navigator.properties.ProfileBean;
import org.fusesource.ide.fabric8.ui.navigator.properties.ProfilesForm;

public abstract class ProfilesFormSupport
extends FormSupport {
    protected ListViewer featuresList;

    public static void createAddEditDeleteButtons(final ListEditor<String> editor, final ListViewer viewer, Composite buttonBar) {
        ActionSupport addAction = new ActionSupport(editor.getAddButtonLabel(), editor.getAddButtonTooltip(), editor.getAddImageDescriptor()){

            public void run() {
                InputDialog dialog = new InputDialog(Shells.getShell(), editor.getAddDialogLabel(), editor.getAddDialogText(), "", null);
                int result = dialog.open();
                if (result == 0) {
                    String value = dialog.getValue();
                    editor.addValue(value);
                    viewer.setInput(editor.getList());
                    Viewers.refresh((Viewer)viewer);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)value));
                }
            }
        };
        final ActionSupport editAction = new ActionSupport(editor.getEditButtonLabel(), editor.getEditButtonTooltip(), editor.getEditImageDescriptor()){

            public void run() {
                InputDialog dialog;
                int result;
                Object old = Selections.getFirstSelection((Viewer)viewer);
                if (old != null && (result = (dialog = new InputDialog(Shells.getShell(), editor.getEditDialogLabel(), editor.getEditDialogText(), old.toString(), null)).open()) == 0) {
                    String value = dialog.getValue();
                    editor.editValue(value, old.toString());
                    viewer.setInput(editor.getList());
                    Viewers.refresh((Viewer)viewer);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)value));
                }
            }
        };
        Widgets.setDoubleClickAction((StructuredViewer)viewer, (Action)editAction);
        final ActionSupport deleteAction = new ActionSupport(editor.getDeleteButtonLabel(), editor.getDeleteButtonTooltip(), editor.getDeleteImageDescriptor()){

            public void run() {
                Object old = Selections.getFirstSelection((Viewer)viewer);
                if (old != null) {
                    editor.removeValue(old.toString());
                    viewer.setInput(editor.getList());
                    Viewers.refresh((Viewer)viewer);
                }
            }
        };
        Widgets.createActionButton((Composite)buttonBar, (Action)addAction);
        final Button editButton = Widgets.createActionButton((Composite)buttonBar, (Action)editAction);
        final Button deleteButton = Widgets.createActionButton((Composite)buttonBar, (Action)deleteAction);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean selected = Selections.getFirstSelection((Viewer)viewer) != null;
                editAction.setEnabled(selected);
                editButton.setEnabled(selected);
                deleteAction.setEnabled(selected);
                deleteButton.setEnabled(selected);
            }
        };
        viewer.addSelectionChangedListener(listener);
        listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)viewer, (ISelection)new StructuredSelection()));
    }

    public ProfilesFormSupport() {
    }

    protected boolean isMandatory(Object bean, String propertyName) {
        return false;
    }

    public void setFocus() {
        if (this.featuresList != null) {
            this.featuresList.getControl().setFocus();
        }
    }

    protected String getFormHeader() {
        return Messages.profilesForm_header;
    }

    protected void createProfileForm(final ProfileDTO profile, Composite inner) {
        ProfileBean bean = new ProfileBean(profile);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        ListViewer featuresList = this.createBeanPropertyList(inner, (Object)bean, "features", Messages.profile_featuresLabel, Messages.profile_featuresTooltip, new ListEditor<String>(Messages.profile_addFeatureButtonLabel, Messages.profile_addFeatureButtonTooltip, Messages.profile_editFeatureButtonLabel, Messages.profile_editFeatureButtonTooltip, Messages.profile_deleteFeatureButtonLabel, Messages.profile_deleteFeatureButtonTooltip, Messages.profile_addFeatureDialogTitle, Messages.profile_addFeatureDialogText, Messages.profile_editFeatureDialogTitle, Messages.profile_editFeatureDialogText, Messages.profile_deleteFeatureDialogTitle){

            @Override
            public List<String> getList() {
                return profile.getFeatures();
            }

            @Override
            public void setList(List<String> list) {
                profile.setFeatures(list);
            }
        });
        this.createBeanPropertyList(inner, (Object)bean, "repositories", Messages.profile_repositoriesLabel, Messages.profile_repositoriesTooltip, new ListEditor<String>(Messages.profile_addRepositoryButtonLabel, Messages.profile_addRepositoryButtonTooltip, Messages.profile_editRepositoryButtonLabel, Messages.profile_editRepositoryButtonTooltip, Messages.profile_deleteRepositoryButtonLabel, Messages.profile_deleteRepositoryButtonTooltip, Messages.profile_addRepositoryDialogTitle, Messages.profile_addRepositoryDialogText, Messages.profile_editRepositoryDialogTitle, Messages.profile_editRepositoryDialogText, Messages.profile_deleteRepositoryDialogTitle){

            @Override
            public List<String> getList() {
                return profile.getRepositories();
            }

            @Override
            public void setList(List<String> list) {
                profile.setRepositories(list);
            }
        });
        this.createBeanPropertyList(inner, (Object)bean, "bundles", Messages.profile_bundlesLabel, Messages.profile_bundlesTooltip, new ListEditor<String>(Messages.profile_addBundleButtonLabel, Messages.profile_addBundleButtonTooltip, Messages.profile_editBundleButtonLabel, Messages.profile_editBundleButtonTooltip, Messages.profile_deleteBundleButtonLabel, Messages.profile_deleteBundleButtonTooltip, Messages.profile_addBundleDialogTitle, Messages.profile_addBundleDialogText, Messages.profile_editBundleDialogTitle, Messages.profile_editBundleDialogText, Messages.profile_deleteBundleDialogTitle){

            @Override
            public List<String> getList() {
                return profile.getBundles();
            }

            @Override
            public void setList(List<String> list) {
                profile.setBundles(list);
            }
        });
        this.createBeanPropertyList(inner, (Object)bean, "fabs", Messages.profile_fabsLabel, Messages.profile_fabsTooltip, new ListEditor<String>(Messages.profile_addFabButtonLabel, Messages.profile_addFabButtonTooltip, Messages.profile_editFabButtonLabel, Messages.profile_editFabButtonTooltip, Messages.profile_deleteFabButtonLabel, Messages.profile_deleteFabButtonTooltip, Messages.profile_addFabDialogTitle, Messages.profile_addFabDialogText, Messages.profile_editFabDialogTitle, Messages.profile_editFabDialogText, Messages.profile_deleteFabDialogTitle){

            @Override
            public List<String> getList() {
                return profile.getFabs();
            }

            @Override
            public void setList(List<String> list) {
                profile.setFabs(list);
            }
        });
        if (this.featuresList == null) {
            this.featuresList = featuresList;
        }
    }

    protected ListViewer createBeanPropertyList(Composite parent, Object bean, String propertyName, String labelText, String tooltip, ListEditor<String> editor) {
        ListViewer viewer = this.createBeanPropertyList(parent, bean, propertyName, labelText, tooltip, 2056);
        viewer.setInput(editor.getList());
        Composite buttonBar = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 0x1000000;
        buttonBar.setLayoutData((Object)gridData);
        RowLayout layout = new RowLayout();
        layout.center = true;
        buttonBar.setLayout((Layout)layout);
        ProfilesForm.createAddEditDeleteButtons(editor, viewer, buttonBar);
        return viewer;
    }

    public void okPressed() {
    }

    public ProfilesFormSupport(ICanValidate validator) {
        super(validator);
    }
}

