/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.properties;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.Messages;
import org.fusesource.ide.fabric8.ui.actions.ProfileTreeSelectionFormSupport;
import org.fusesource.ide.fabric8.ui.navigator.ContainerNode;

public class ProfileTreeForm
extends ProfileTreeSelectionFormSupport {
    private final ContainerNode node;
    private boolean selectionChanged = false;

    public ProfileTreeForm(ContainerNode node) {
        this.node = node;
        this.selectionChanged = false;
    }

    public void setFocus() {
        this.getProfilesViewer().getControl().setFocus();
    }

    protected void createTextFields(Composite parent) {
        Composite outer = this.createSectionComposite(Messages.profilesForm_header, new GridData(1808));
        GridLayout layout = new GridLayout();
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        outer.setLayout((Layout)layout);
        this.createColumnsViewer(outer);
        this.createButtons(parent);
        this.setProfilesViewerInput((Object)this.node.getVersionNode());
        List profiles = this.node.getContainer().getProfiles();
        this.setCheckedProfiles(profiles);
        this.getProfilesViewer().getTree().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (ProfileTreeForm.this.selectionChanged) {
                    if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.confirmProfileSelectionChangesTitle, (String)Messages.confirmProfileSelectionChangesText)) {
                        if (ProfileTreeForm.this.isValid()) {
                            ProfileTreeForm.this.okPressed();
                        }
                    } else {
                        ProfileTreeForm.this.getProfilesViewer().getTree().deselectAll();
                        ProfileTreeForm.this.setProfilesViewerInput((Object)ProfileTreeForm.this.node.getVersionNode());
                        List profiles = ProfileTreeForm.this.node.getContainer().getProfiles();
                        ProfileTreeForm.this.setCheckedProfiles(profiles);
                        ProfileTreeForm.this.getProfilesViewer().refresh();
                    }
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    @Override
    protected void onProfileSelectionChanged() {
        super.onProfileSelectionChanged();
        this.selectionChanged = true;
    }

    public void okPressed() {
        ProfileDTO[] profiles = this.getSelectedProfileArray();
        ContainerDTO agent = this.node.getContainer();
        FabricPlugin.getLogger().debug("Updating the profiles of " + agent + " to: " + Arrays.asList(profiles));
        agent.setProfileDTOs(Arrays.asList(profiles));
        this.node.refresh();
        this.selectionChanged = false;
    }

    @Override
    protected Composite createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        button.setLayoutData((Object)gridData);
    }
}

