/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.cloud;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsCachedData;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsDeleteAction;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsEditAction;
import org.fusesource.ide.fabric8.ui.navigator.cloud.CloudDetailsView;
import org.fusesource.ide.fabric8.ui.navigator.cloud.CloudTabViewPage;
import org.fusesource.ide.fabric8.ui.navigator.cloud.CloudsNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;
import org.jclouds.compute.ComputeService;

public class CloudNode
extends RefreshableCollectionNode
implements ImageProvider,
HasRefreshableUI,
ContextMenuProvider,
ITabbedPropertySheetPageContributor {
    private static final String CONTRIBUTOR_ID = "org.fusesource.ide.fabric.navigator";
    private final CloudsNode cloudsNode;
    private final CloudDetails details;
    private AtomicBoolean loaded = new AtomicBoolean(false);
    private boolean lazyLoad;
    private CloudDetailsEditAction editAction;
    private CloudDetailsDeleteAction deleteAction;
    private CloudDetailsCachedData cloudData;

    public CloudNode(CloudsNode cloudsNode, CloudDetails details) {
        super((Node)cloudsNode);
        this.cloudsNode = cloudsNode;
        this.details = details;
        this.cloudData = CloudDetailsCachedData.getInstance(details);
        this.setPropertyBean(new CloudDetailsView(details));
        this.editAction = new CloudDetailsEditAction(){

            @Override
            protected CloudDetails getSelectedCloudDetails() {
                return CloudNode.this.getDetails();
            }

            @Override
            protected void onCloudDetailsEdited(Object found) {
            }
        };
        this.deleteAction = new CloudDetailsDeleteAction(){

            @Override
            protected CloudDetails getSelectedCloudDetails() {
                return CloudNode.this.getDetails();
            }
        };
    }

    public String toString() {
        return this.getName();
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)this.editAction);
        menu.add((IAction)this.deleteAction);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new CloudTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public String getName() {
        return this.details.getName();
    }

    public CloudsNode getCloudsNode() {
        return this.cloudsNode;
    }

    public ComputeService getComputeService() {
        return this.cloudData.getComputeClient();
    }

    public CloudDetails getDetails() {
        return this.details;
    }

    public RefreshableUI getRefreshableUI() {
        return this.cloudsNode.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("cloud.png");
    }

    protected void loadChildren() {
    }

    public WritableList getNodes() {
        if (this.loaded.compareAndSet(false, true)) {
            this.reloadNodes();
        }
        return this.cloudData.getNodePropertyList();
    }

    public void reloadNodes() {
        this.cloudData.reloadNodes();
    }

    public String getContributorId() {
        return CONTRIBUTOR_ID;
    }
}

