/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.HasOwner;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.ProfileAddAction;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionsNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class VersionNode
extends FabricNodeSupport
implements HasRefreshableUI,
ImageProvider,
ContextMenuProvider {
    private Map<String, ProfileNode> map = new HashMap<String, ProfileNode>();
    private Map<String, Set<ProfileDTO>> childrenMap = new HashMap<String, Set<ProfileDTO>>();
    private final Fabric fabric;
    private final VersionDTO version;

    public VersionNode(VersionsNode parent, VersionDTO version) {
        super((Node)parent, parent.getFabric());
        this.fabric = parent.getFabric();
        this.version = version;
        this.setPropertyBean(version);
    }

    public String toString() {
        return this.version.getId();
    }

    public VersionDTO getVersion() {
        return this.version;
    }

    public RefreshableUI getRefreshableUI() {
        return super.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("version.png");
    }

    protected void loadChildren() {
        this.map.clear();
        this.childrenMap.clear();
        List<ProfileDTO> profiles = this.getVersionProfiles();
        HashMap<String, ProfileDTO> profileMap = new HashMap<String, ProfileDTO>();
        for (ProfileDTO profile : profiles) {
            String id = profile.getId();
            profileMap.put(id, profile);
            List parents = profile.getParents();
            for (ProfileDTO parent : parents) {
                String pid = parent.getId();
                Set<ProfileDTO> childSet = this.childrenMap.get(pid);
                if (childSet == null) {
                    childSet = new HashSet<ProfileDTO>();
                    this.childrenMap.put(pid, childSet);
                }
                childSet.add(profile);
            }
        }
        for (ProfileDTO profile : profiles) {
            List parents = profile.getParents();
            if (parents != null && parents.size() != 0) continue;
            ProfileNode node = this.createProfile((Node)this, profile);
            this.addChild((Node)node);
        }
    }

    public List<ProfileDTO> getVersionProfiles() {
        return this.version.getProfiles();
    }

    public List<ProfileNode> getAllProfileNodes() {
        ArrayList<ProfileNode> answer = new ArrayList<ProfileNode>();
        List<ProfileDTO> profiles = this.getVersionProfiles();
        if (profiles != null) {
            for (ProfileDTO profile : profiles) {
                ProfileNode node = this.getProfileNode(profile);
                if (node == null) continue;
                answer.add(node);
            }
        }
        Collections.sort(answer);
        return answer;
    }

    public ProfileNode createProfile(Node parent, ProfileDTO profile) {
        ProfileNode node = new ProfileNode(this, parent, profile);
        this.map.put(node.getProfileId(), node);
        return node;
    }

    @Override
    public Fabric getFabric() {
        return this.fabric;
    }

    public String getVersionId() {
        return this.version.getId();
    }

    public ProfileNode getProfileNode(String profileId) {
        this.checkLoaded();
        ProfileNode answer = this.map.get(profileId);
        if (answer == null) {
            answer = ProfileNode.getProfileNode(profileId, this.getProfileChildren());
        }
        return answer;
    }

    public ProfileNode getProfileNode(ProfileDTO profile) {
        return this.getProfileNode(profile.getId());
    }

    public ProfileNode[] getProfileChildren() {
        return (ProfileNode[])Objects.getArrayOf((Collection)this.getChildrenList(), ProfileNode.class);
    }

    public <T extends Node> T[] getChildrenOf(Class<T> aType) {
        List list = this.getChildrenList();
        ArrayList<Node> answer = new ArrayList<Node>(list.size());
        for (Node node : list) {
            if (!aType.isInstance(node)) continue;
            answer.add((Node)aType.cast(node));
        }
        Node[] array = (Node[])Array.newInstance(aType, list.size());
        return list.toArray(array);
    }

    public Set<ProfileDTO> getChildProfiles(String profileId) {
        return this.childrenMap.get(profileId);
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new ProfileAddAction(this));
    }

    public static VersionNode toVersionNode(Object object) {
        if (object instanceof VersionNode) {
            return (VersionNode)((Object)object);
        }
        if (object instanceof HasOwner) {
            HasOwner ho = (HasOwner)object;
            return VersionNode.toVersionNode(ho.getOwner());
        }
        return null;
    }

    public static VersionDTO toVersion(Object object) {
        if (object instanceof VersionDTO) {
            return (VersionDTO)object;
        }
        VersionNode node = VersionNode.toVersionNode(object);
        if (node != null) {
            return node.getVersion();
        }
        return null;
    }
}

