/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import com.google.common.base.Objects;
import io.fabric8.api.CreateContainerOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.tree.GraphableNode;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.HasViewer;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.actions.HasDoubleClickAction;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerMetadataDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerOptionsDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileStatusDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricConnectionListener;
import org.fusesource.ide.fabric8.ui.FabricConnector;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.FabricConnectAction;
import org.fusesource.ide.fabric8.ui.actions.FabricDetails;
import org.fusesource.ide.fabric8.ui.actions.FabricDetailsDeleteAction;
import org.fusesource.ide.fabric8.ui.actions.FabricDetailsEditAction;
import org.fusesource.ide.fabric8.ui.actions.FabricDisconnectAction;
import org.fusesource.ide.fabric8.ui.navigator.ContainerNode;
import org.fusesource.ide.fabric8.ui.navigator.ContainersNode;
import org.fusesource.ide.fabric8.ui.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric8.ui.navigator.Fabrics;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionsNode;
import org.fusesource.ide.fabric8.ui.navigator.properties.FabricTabViewPage;
import org.fusesource.ide.fabric8.ui.view.logs.FabricLogBrowser;
import org.fusesource.ide.fabric8.ui.view.logs.HasLogBrowser;
import org.fusesource.ide.fabric8.ui.view.logs.ILogBrowser;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class Fabric
extends FabricNodeSupport
implements ImageProvider,
HasRefreshableUI,
GraphableNode,
ContextMenuProvider,
HasDoubleClickAction,
FabricConnectionListener,
HasLogBrowser {
    public static final String DEFAULT_NAME = "Fabric";
    private static final boolean changeSelectionOnCreate = false;
    private static final boolean changeSelectionOnConnect = false;
    private String userName = "admin";
    private String password = "admin";
    private FabricConnector connector;
    private final Fabrics fabrics;
    private ContainersNode containersNode;
    private VersionsNode versionsNode;
    private FabricDetailsEditAction editAction;
    private FabricDetailsDeleteAction deleteAction;
    private FabricDetails details;
    private ILogBrowser logBrowser;
    private boolean selectContainersOnCreate = true;
    private Set<Runnable> fabricUpdateTasks = new HashSet<Runnable>();

    public Fabric(Fabrics fabrics, FabricDetails details) {
        super((Node)fabrics, null);
        this.fabrics = fabrics;
        this.details = details;
        this.userName = details.getUserName();
        this.password = details.getPassword();
        super.setFabric(this);
        this.editAction = new FabricDetailsEditAction(){

            @Override
            protected FabricDetails getSelectedFabricDetails() {
                return Fabric.this.getDetails();
            }

            @Override
            protected void onFabricDetailsEdited(FabricDetails found) {
                Fabric.this.setDetails(found);
            }
        };
        this.deleteAction = new FabricDetailsDeleteAction(){

            @Override
            protected FabricDetails getSelectedFabricDetails() {
                return Fabric.this.getDetails();
            }
        };
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new FabricTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public boolean requiresContentsPropertyPage() {
        return false;
    }

    public Fabric8Facade getFabricService() {
        if (this.connector != null) {
            return this.connector.getFabricService();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public FabricDetails getDetails() {
        return this.details;
    }

    public void addFabricUpdateRunnable(Runnable runnable) {
        this.fabricUpdateTasks.add(runnable);
        FabricPlugin.getLogger().debug("=============== Now have " + this.fabricUpdateTasks.size() + " runnables");
    }

    public void removeFabricUpdateRunnable(Runnable runnable) {
        this.fabricUpdateTasks.remove(runnable);
    }

    public void setDetails(FabricDetails details) {
        String oldUrls = this.details.getUrls();
        this.details = details;
        String newUrls = details.getUrls();
        if (!Objects.equal((Object)oldUrls, (Object)newUrls)) {
            this.setConnector(new FabricConnector(this));
        }
    }

    public RefreshableUI getRefreshableUI() {
        return this.fabrics.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("fabric8.png");
    }

    protected synchronized void loadChildren() {
        this.clearChildren();
        if (!this.isConnected()) {
            return;
        }
        this.containersNode = new ContainersNode(this);
        this.versionsNode = new VersionsNode(this);
        this.addChild((Node)this.containersNode);
        this.addChild((Node)this.versionsNode);
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new FabricConnectAction(this));
        menu.add((IAction)new FabricDisconnectAction(this));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editAction);
        menu.add((IAction)this.deleteAction);
    }

    public VersionNode getDefaultVersionNode() {
        if (!this.isConnected() || this.versionsNode == null) {
            return null;
        }
        return this.versionsNode.getDefaultVersionNode();
    }

    @Override
    public List<Node> getChildrenGraph() {
        HashSet<Fabric> answer = new HashSet<Fabric>();
        if (this.isConnected()) {
            answer.add(this);
            answer.addAll(this.getChildrenList());
        }
        return new ArrayList<Node>(answer);
    }

    public Action getDoubleClickAction() {
        return new FabricConnectAction(this);
    }

    protected void addChildren(Set<Node> set, Node node, boolean showVersions) {
        if (node != null && this.isConnected()) {
            List childrenList = node.getChildrenList();
            for (Node child : childrenList) {
                if (child instanceof ProfileNode || child instanceof VersionNode) {
                    this.addChildren(set, child, showVersions);
                } else if (!(child instanceof ContainerNode) && !showVersions && child instanceof VersionNode) continue;
                set.add(child);
            }
        }
    }

    public List<ContainerNode> getAgentsFor(ProfileDTO profile) {
        ArrayList<ContainerNode> answer = new ArrayList<ContainerNode>();
        if (this.containersNode != null && this.isConnected()) {
            Node[] children;
            Node[] nodeArray = children = this.containersNode.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ContainerNode agent;
                Node node = nodeArray[n2];
                if (node instanceof ContainerNode && (agent = (ContainerNode)node).matches(profile)) {
                    answer.add(agent);
                }
                ++n2;
            }
        }
        return answer;
    }

    public ContainersNode getContainersNode() {
        return this.containersNode;
    }

    public VersionsNode getVersionsNode() {
        return this.versionsNode;
    }

    public String getName() {
        return this.details.getName();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public FabricConnector getConnector() {
        return this.connector;
    }

    public void setConnector(FabricConnector conn) {
        if (conn == null && this.connector != null) {
            this.connector.removeFabricConnectionListener(this);
        }
        this.connector = conn;
        if (this.connector != null) {
            this.connector.addFabricConnectionListener(this);
        }
    }

    public boolean isConnected() {
        if (this.connector == null) {
            return false;
        }
        return this.connector.isConnected();
    }

    public Collection<ProfileNode> getProfileNodes(List<ProfileDTO> profiles) {
        HashSet<ProfileNode> answer = new HashSet<ProfileNode>();
        if (this.isConnected()) {
            for (ProfileDTO profile : profiles) {
                ProfileNode profileNode;
                VersionNode version = this.getVersionNode(profile.getVersionId());
                if (version == null || (profileNode = version.getProfileNode(profile)) == null) continue;
                answer.add(profileNode);
            }
        }
        return answer;
    }

    public VersionNode getVersionNode(String version) {
        if (this.versionsNode != null) {
            return this.versionsNode.getVersionNode(version);
        }
        return null;
    }

    public VersionDTO getVersion(String versionName) {
        VersionNode node = this.getVersionNode(versionName);
        if (node != null) {
            return node.getVersion();
        }
        return null;
    }

    public void createContainer(ContainerDTO agent, final ProfileDTO[] profiles, final CreateContainerOptionsDTO args) {
        if (!this.isConnected()) {
            return;
        }
        try {
            Jobs.schedule((Job[])new Job[]{new Job("Create container"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Fabric8Facade fabricService = Fabric.this.getFabricService();
                        final CreateContainerMetadataDTO[] newAgents = fabricService.createContainers(args);
                        Viewers.async((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CreateContainerMetadataDTO[] createContainerMetadataDTOArray = newAgents;
                                int n = newAgents.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CreateContainerMetadataDTO metadata = createContainerMetadataDTOArray[n2];
                                    ContainerDTO newContainer = metadata.getContainer();
                                    if (newContainer != null) {
                                        Fabric.this.setContainerProfiles(newContainer, profiles);
                                        Fabric.this.refreshCreatedAgent(args.getName());
                                    }
                                    ++n2;
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (Throwable e) {
                        return new Status(4, "org.fusesource.ide.fabric8.ui", "Failed to create container: " + e, e);
                    }
                }
            }});
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to create new child container of " + this, e.getMessage(), e);
        }
    }

    public void createContainer(ContainerDTO agent, final ProfileDTO[] profiles, final CreateContainerOptions args) {
        if (!this.isConnected()) {
            return;
        }
        try {
            Jobs.schedule((Job[])new Job[]{new Job("Create container"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Fabric8Facade fabricService = Fabric.this.getFabricService();
                        final CreateContainerMetadataDTO[] newAgents = fabricService.createContainers(args);
                        Viewers.async((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CreateContainerMetadataDTO[] createContainerMetadataDTOArray = newAgents;
                                int n = newAgents.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CreateContainerMetadataDTO metadata = createContainerMetadataDTOArray[n2];
                                    ContainerDTO newContainer = metadata.getContainer();
                                    if (newContainer != null) {
                                        Fabric.this.setContainerProfiles(newContainer, profiles);
                                        Fabric.this.refreshCreatedAgent(args.getName());
                                    }
                                    ++n2;
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (Throwable e) {
                        return new Status(4, "org.fusesource.ide.fabric8.ui", "Failed to create container: " + e, e);
                    }
                }
            }});
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to create new child container of " + this, e.getMessage(), e);
        }
    }

    public void setContainerProfiles(ContainerDTO newContainer, ProfileDTO[] profiles) {
        if (!this.isConnected() || newContainer == null) {
            return;
        }
        VersionDTO version = this.getProfilesVersion(profiles);
        if (version != null) {
            newContainer.setVersion(version);
        }
        newContainer.setProfileDTOs(Arrays.asList(profiles));
    }

    public VersionDTO getProfilesVersion(ProfileDTO[] profiles) {
        VersionDTO version = null;
        if (this.isConnected()) {
            ProfileDTO[] profileDTOArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDTO profile = profileDTOArray[n2];
                String versionName = profile.getVersionId();
                if (versionName != null) {
                    version = this.getVersion(versionName);
                }
                ++n2;
            }
        }
        return version;
    }

    public void refreshCreatedAgent(String agentName) {
        if (!this.isConnected()) {
            return;
        }
        Fabric fabric = this;
        ContainersNode containers = this.getContainersNode();
        if (containers != null) {
            containers.refresh();
        }
    }

    public String getNewAgentName() {
        return "container" + (this.getContainersNode().getChildCount() + 1);
    }

    public List<ContainerNode> getRootContainers() {
        ArrayList<ContainerNode> answer = new ArrayList<ContainerNode>();
        if (this.containersNode != null) {
            for (ContainerNode node : this.containersNode.getContainerNodes()) {
                if (!node.getContainer().isRoot().booleanValue()) continue;
                answer.add(node);
            }
        }
        return answer;
    }

    public void onZooKeeperUpdate() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                FabricPlugin.getLogger().debug("Refreshing Fabric " + this + " due to ZK change!");
                Fabric.this.getContainersNode().refresh();
                for (Runnable task : Fabric.this.fabricUpdateTasks) {
                    task.run();
                }
            }
        });
    }

    public Collection<ProfileStatusDTO> getProfileStatuses() {
        Fabric8Facade service = this.getFabricService();
        if (service == null || service.getFabricStatus() == null || !this.isConnected()) {
            return new ArrayList<ProfileStatusDTO>();
        }
        return service.getFabricStatus().getProfileStatusMap().values();
    }

    @Override
    public void onFabricConnected() {
        RefreshableUI refreshableUI = this.getRefreshableUI();
        if (refreshableUI instanceof HasViewer) {
            HasViewer hv = (HasViewer)refreshableUI;
            Viewer viewer = hv.getViewer();
            final Fabric fabric = this;
            if (viewer instanceof CommonViewer) {
                final CommonViewer cv = (CommonViewer)viewer;
                UIJob job = new UIJob("Connecting to " + this + "..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        cv.expandToLevel((Object)fabric, 1);
                        Fabric.this.setPropertyBean(Fabric.this.connector);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    @Override
    public void onFabricDisconnected() {
        FabricConnector conn = this.getConnector();
        if (conn != null) {
            conn.dispose();
        }
        this.setConnector(null);
        this.setPropertyBean(this.connector);
        this.refresh();
    }

    @Override
    public ILogBrowser getLogBrowser() {
        if (this.logBrowser == null) {
            this.logBrowser = new FabricLogBrowser(this);
        }
        return this.logBrowser;
    }
}

