/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions.jclouds;

import io.fabric8.api.CreationStateListener;
import io.fabric8.service.jclouds.CreateJCloudsContainerMetadata;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import io.fabric8.service.jclouds.JcloudsContainerProvider;
import io.fabric8.service.jclouds.firewall.ApiFirewallSupport;
import io.fabric8.service.jclouds.firewall.FirewallManagerFactory;
import io.fabric8.service.jclouds.firewall.internal.Ec2FirewallSupport;
import io.fabric8.service.jclouds.firewall.internal.FirewallManagerFactoryImpl;
import io.fabric8.service.jclouds.firewall.internal.NovaFirewallSupport;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.FabricDetails;
import org.fusesource.ide.fabric8.ui.actions.FabricDetailsAddAction;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsWizardPage;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudFabricDetailsForm;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudFabricDetailsWizardPage;
import org.fusesource.ide.fabric8.ui.navigator.Fabrics;
import org.jclouds.compute.ComputeService;

public class CreateJCloudsFabricWizard
extends Wizard {
    private final Fabrics fabrics;
    private final String defaultAgentName;
    private IStructuredSelection selection;
    private CloudDetailsWizardPage page1;
    private CloudFabricDetailsWizardPage page2;

    public CreateJCloudsFabricWizard(Fabrics fabrics, String defaultAgentName) {
        this.fabrics = fabrics;
        this.defaultAgentName = defaultAgentName;
        super.setWindowTitle(Messages.createJCloudsFabricTitle);
        super.setDefaultPageImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("fabric8_logo.png"));
    }

    public String getDefaultAgentName() {
        return this.defaultAgentName;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public CloudDetailsWizardPage getPage1() {
        return this.page1;
    }

    public CloudFabricDetailsWizardPage getPage2() {
        return this.page2;
    }

    public void addPages() {
        this.page1 = new CloudDetailsWizardPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new CloudFabricDetailsWizardPage(this);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        final CloudFabricDetailsForm form = this.getPage2().getForm();
        form.saveSettings();
        Jobs.schedule((Job[])new Job[]{new Job("Create container"){

            protected IStatus run(final IProgressMonitor monitor) {
                final String fabricName = form.getFabricName();
                String agentName = form.getAgentName();
                CreateJCloudsContainerOptions.Builder args = form.getCreateCloudArguments();
                String proxyUri = form instanceof CloudFabricDetailsForm ? form.getProxyUri() : "https://repository.jboss.org/nexus/content/groups/ea";
                try {
                    args = (CreateJCloudsContainerOptions.Builder)args.name(agentName);
                    args = (CreateJCloudsContainerOptions.Builder)args.ensembleServer(true);
                    args = (CreateJCloudsContainerOptions.Builder)args.adminAccess(true);
                    if (!Strings.isBlank((String)proxyUri)) {
                        args = (CreateJCloudsContainerOptions.Builder)args.proxyUri(new URI(proxyUri));
                    }
                    FabricPlugin.getLogger().debug("============ proxy URI: " + args.getProxyUri());
                    FabricPlugin.getLogger().debug("Create cloud fabric: " + fabricName + " container: " + agentName);
                    FirewallManagerFactoryImpl firewallManagerFactory = new FirewallManagerFactoryImpl();
                    firewallManagerFactory.activateComponent();
                    Ec2FirewallSupport ec2fw = new Ec2FirewallSupport();
                    ec2fw.activateComponent();
                    firewallManagerFactory.bindFirewallSupport((ApiFirewallSupport)ec2fw);
                    NovaFirewallSupport novafw = new NovaFirewallSupport();
                    novafw.activateComponent();
                    firewallManagerFactory.bindFirewallSupport((ApiFirewallSupport)novafw);
                    JcloudsContainerProvider provider = new JcloudsContainerProvider();
                    provider.activateComponent();
                    provider.bindFirewallManagerFactory((FirewallManagerFactory)firewallManagerFactory);
                    String providerName = args.getProviderName();
                    args = args.contextName(providerName);
                    ComputeService computeClient = CloudDetails.createComputeService(CreateJCloudsFabricWizard.this.getSelectedCloud());
                    args = args.computeService(computeClient);
                    FabricPlugin.getLogger().debug("Creating Jclouds provider type: " + providerName);
                    CreateJCloudsContainerOptions opts = ((CreateJCloudsContainerOptions.Builder)args.withUser(args.getUser(), args.getPassword(), "admin")).build();
                    FabricPlugin.getLogger().debug("Compute Service: " + opts.getComputeService());
                    CreateJCloudsContainerMetadata metadata = provider.create(opts, new CreationStateListener(){

                        public void onStateChange(String message) {
                            monitor.subTask(message);
                        }
                    });
                    Throwable failure = metadata.getFailure();
                    if (failure != null) {
                        return new Status(4, "org.fusesource.ide.fabric8.ui", "Failed to create Fabric: " + fabricName, failure);
                    }
                    final StringBuilder urisBuilder = new StringBuilder();
                    for (String address : metadata.getPublicAddresses()) {
                        urisBuilder.append(address).append(",");
                    }
                    final CreateJCloudsContainerOptions.Builder arguments = args;
                    Viewers.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String uris = urisBuilder.toString();
                            if (uris.endsWith(",")) {
                                uris = uris.substring(0, uris.length() - 1);
                            }
                            FabricPlugin.getLogger().debug("Creating fabric with uris: " + uris);
                            FabricDetails details = FabricDetails.newInstance(fabricName, uris);
                            details.setUserName(arguments.getUser());
                            details.setPassword(arguments.getPassword());
                            details.setZkPassword(arguments.getZookeeperPassword());
                            new FabricDetailsAddAction(CreateJCloudsFabricWizard.this.fabrics).addCloud(details);
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (Throwable e) {
                    return new Status(4, "org.fusesource.ide.fabric8.ui", "Failed to create Fabric: " + fabricName, e);
                }
            }
        }});
        return true;
    }

    public CloudDetails getSelectedCloud() {
        return this.page1.getSelectedCloud();
    }
}

