/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions.jclouds;

import io.fabric8.api.CreateContainerOptions;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudContainerDetailsForm;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudContainerDetailsWizardPage;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsWizardPage;
import org.fusesource.ide.fabric8.ui.navigator.ContainerNode;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;

public class CreateJCloudsContainerWizard
extends Wizard {
    private static final String PUBLIC_IP = "publicip";
    private final VersionNode versionNode;
    private final ContainerNode selectedAgent;
    private final String defaultAgentName;
    private final ProfileNode selectedProfile;
    private IStructuredSelection selection;
    private CloudDetailsWizardPage page1;
    private CloudContainerDetailsWizardPage page2;

    public CreateJCloudsContainerWizard(VersionNode versionNode, ContainerNode selectedAgent, String defaultAgentName, ProfileNode selectedProfile) {
        this.versionNode = versionNode;
        this.selectedAgent = selectedAgent;
        this.defaultAgentName = defaultAgentName;
        this.selectedProfile = selectedProfile;
        super.setWindowTitle(Messages.createJCloudsAgentTitle);
    }

    public VersionNode getVersionNode() {
        return this.versionNode;
    }

    public ContainerNode getSelectedAgent() {
        return this.selectedAgent;
    }

    public String getDefaultAgentName() {
        return this.defaultAgentName;
    }

    public ProfileNode getSelectedProfile() {
        return this.selectedProfile;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public CloudDetailsWizardPage getPage1() {
        return this.page1;
    }

    public CloudContainerDetailsWizardPage getPage2() {
        return this.page2;
    }

    public void addPages() {
        this.page1 = new CloudDetailsWizardPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new CloudContainerDetailsWizardPage(this);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        String zkUrl;
        Map config;
        ProfileDTO profile;
        CloudContainerDetailsForm form = this.getPage2().getForm();
        form.saveSettings();
        String agentName = form.getAgentName();
        CreateJCloudsContainerOptions.Builder args = form.getCreateCloudArguments();
        args.name(agentName);
        args.resolver(PUBLIC_IP);
        Fabric fabric = this.getFabric();
        ProfileNode defaultProfile = this.getVersionNode().getProfileNode("default");
        if (defaultProfile != null && fabric != null && (profile = defaultProfile.getProfile()) != null && (config = (Map)profile.getConfigurations().get("io.fabric8.zookeeper")) != null && (zkUrl = (String)config.get("zookeeper.url")) != null) {
            try {
                FabricPlugin.getLogger().debug("TODO: HOW TO GET THE CURATOR FRAMEWORK");
                CuratorFramework curator = null;
                zkUrl = ZooKeeperUtils.getSubstitutedData(curator, (String)zkUrl);
                args.zookeeperUrl(zkUrl);
            }
            catch (Exception e) {
                FabricPlugin.getLogger().warning("Failed to get ZooKeeperURL: " + e, (Throwable)e);
            }
        }
        ContainerDTO agent = null;
        if (this.selectedAgent != null) {
            agent = this.selectedAgent.getContainer();
        }
        ProfileDTO[] profiles = form.getSelectedProfileArray();
        this.versionNode.getFabric().createContainer(agent, profiles, (CreateContainerOptions)args.build());
        return true;
    }

    public Fabric getFabric() {
        return this.versionNode != null ? this.versionNode.getFabric() : (this.selectedProfile != null ? this.selectedProfile.getFabric() : (this.selectedAgent != null ? this.selectedAgent.getFabric() : null));
    }

    public CloudDetails getSelectedCloud() {
        return this.page1.getSelectedCloud();
    }
}

