/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions.jclouds;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.fusesource.ide.commons.ui.config.ConfigurationDetails;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsKey;
import org.fusesource.ide.fabric8.ui.actions.jclouds.JClouds;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.management.ManagementContext;
import org.jclouds.management.config.ManagementLifecycle;
import org.jclouds.management.internal.BaseManagementContext;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CloudDetails
extends ConfigurationDetails {
    public static final String PROPERTY_SETTINGS_PREFIX = "settings_";
    public static final String PROPERTY_PROVIDER_ID = "providerId";
    public static final String PROPERTY_API_ID = "apiId";
    public static final String PROPERTY_ENDPOINT = "endpoint";
    public static final String PROPERTY_OWNER_ID = "ownerId";
    public static final String PROPERTY_CREDENTIAL = "credential";
    public static final String PROPERTY_IDENTITY = "identity";
    public static final String PROPERTY_NAME = "name";
    private static WritableList cloudDetailList = WritableList.withElementType(CloudDetails.class);
    private static AtomicBoolean loadedCloudDetails = new AtomicBoolean(false);
    private static CloudDetails exemplar = new CloudDetails();
    private String name;
    private ProviderMetadata provider;
    private ApiMetadata api;
    private String identity;
    private String credential;
    private String ownerId;
    private boolean storeCredential = true;
    private String providerId;
    private String apiId;
    private String endpoint;
    private CloudDetailsKey key;
    private HashMap<String, String> settings = new HashMap();

    public static void reloadCloudDetailList() {
        cloudDetailList.clear();
        CloudDetails.load((Collection<CloudDetails>)cloudDetailList);
    }

    public static WritableList getCloudDetailList() {
        if (loadedCloudDetails.compareAndSet(false, true)) {
            CloudDetails.load((Collection<CloudDetails>)cloudDetailList);
        }
        return cloudDetailList;
    }

    public static CloudDetails asCloudDetails(Object element) {
        if (element instanceof CloudDetails) {
            return (CloudDetails)((Object)element);
        }
        return null;
    }

    protected static void load(Collection<CloudDetails> cloudDetailList) {
        Preferences node = exemplar.getConfigurationNode();
        try {
            String[] childrenNames;
            String[] stringArray = childrenNames = node.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                cloudDetailList.add(new CloudDetails(name, node.node(name)));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            FabricPlugin.showUserError("Failed to load cloud providers", e.getMessage(), (Exception)((Object)e));
        }
    }

    public static CloudDetails copy(CloudDetails copy) {
        Preferences node = exemplar.getConfigurationNode();
        String id = copy.getId();
        return new CloudDetails(id, node.node(id));
    }

    public CloudDetails() {
    }

    public CloudDetails(String id, Preferences node) {
        super(id);
        this.name = node.get(PROPERTY_NAME, "");
        this.identity = node.get(PROPERTY_IDENTITY, "");
        this.credential = node.get(PROPERTY_CREDENTIAL, "");
        if (Strings.isBlank((String)this.credential)) {
            this.storeCredential = false;
        }
        this.ownerId = node.get(PROPERTY_OWNER_ID, "");
        this.setProvider(JClouds.getProvider(node.get(PROPERTY_PROVIDER_ID, null)));
        this.setApi(JClouds.getApi(node.get(PROPERTY_API_ID, null)));
        this.setEndpoint(node.get(PROPERTY_ENDPOINT, null));
        this.settings.clear();
        try {
            String[] stringArray = node.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyName = stringArray[n2];
                if (keyName.startsWith(PROPERTY_SETTINGS_PREFIX)) {
                    this.settings.put(keyName, node.get(keyName, ""));
                }
                ++n2;
            }
        }
        catch (BackingStoreException ex) {
            FabricPlugin.showUserError("Settings Error", "Unable to restore settings...", (Exception)((Object)ex));
        }
    }

    public CloudDetailsKey getCacheKey() {
        if (this.key == null) {
            this.key = new CloudDetailsKey(this.identity, this.credential, this.ownerId, this.providerId, this.apiId, this.endpoint);
        }
        return this.key;
    }

    protected String getConfigurationNodeId() {
        return "org.fusesource.ide.jclouds.provider";
    }

    protected void store(Preferences node) {
        node.put(PROPERTY_NAME, this.name);
        node.put(PROPERTY_IDENTITY, this.identity);
        if (this.storeCredential) {
            node.put(PROPERTY_CREDENTIAL, this.credential);
        } else {
            node.remove(PROPERTY_CREDENTIAL);
        }
        if (Strings.isBlank((String)this.providerId)) {
            node.remove(PROPERTY_PROVIDER_ID);
        } else {
            node.put(PROPERTY_PROVIDER_ID, this.providerId);
        }
        if (Strings.isBlank((String)this.apiId)) {
            node.remove(PROPERTY_API_ID);
        } else {
            node.put(PROPERTY_API_ID, this.apiId);
        }
        if (Strings.isBlank((String)this.endpoint)) {
            node.remove(PROPERTY_ENDPOINT);
        } else {
            node.put(PROPERTY_ENDPOINT, this.endpoint);
        }
        if (Strings.isBlank((String)this.ownerId)) {
            node.remove(PROPERTY_OWNER_ID);
        } else {
            node.put(PROPERTY_OWNER_ID, this.ownerId);
        }
        for (String keyName : this.settings.keySet()) {
            String value = this.settings.get(keyName);
            node.put(keyName, value);
        }
    }

    public String toString() {
        return "ColumnConfiguration(" + this.name + ", " + this.provider + ", " + this.identity + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProviderMetadata getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderMetadata provider) {
        this.providerId = JClouds.getId(provider);
        if (provider != this.provider) {
            ProviderMetadata oldValue = this.provider;
            this.provider = provider;
            this.firePropertyChange("provider", oldValue, provider);
        }
    }

    public ApiMetadata getApi() {
        return this.api;
    }

    public void setApi(ApiMetadata api) {
        if (api == null) {
            return;
        }
        this.apiId = JClouds.getId(api);
        if (api != this.api) {
            ApiMetadata oldValue = this.api;
            this.api = api;
            this.firePropertyChange("api", oldValue, api);
        }
    }

    public String getEndpoint() {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (this.getProvider() != null) {
            return this.getProvider().getEndpoint();
        }
        if (this.getApi() != null && this.getApi().getDefaultEndpoint().isPresent()) {
            return (String)this.getApi().getDefaultEndpoint().get();
        }
        return null;
    }

    public void setEndpoint(String endpoint) {
        if (endpoint != null && !endpoint.equals(this.endpoint)) {
            String oldValue = this.endpoint;
            this.endpoint = endpoint;
            this.firePropertyChange(PROPERTY_ENDPOINT, oldValue, endpoint);
        }
    }

    public void addSetting(String key, String value) {
        this.settings.put(PROPERTY_SETTINGS_PREFIX + key, value);
        this.firePropertyChange("settings", value, value);
    }

    public String getSetting(String key, String defaultValue) {
        String retVal = defaultValue;
        if (this.settings.containsKey(PROPERTY_SETTINGS_PREFIX + key)) {
            retVal = this.settings.get(PROPERTY_SETTINGS_PREFIX + key);
        }
        return retVal;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        if (!identity.equals(this.identity)) {
            String oldValue = this.identity;
            this.identity = identity;
            this.firePropertyChange(PROPERTY_IDENTITY, oldValue, identity);
        }
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        if (!credential.equals(this.credential)) {
            String oldValue = this.credential;
            this.credential = credential;
            this.firePropertyChange(PROPERTY_CREDENTIAL, oldValue, credential);
        }
    }

    public boolean isStoreCredential() {
        return this.storeCredential;
    }

    public void setStoreCredential(boolean storeCredential) {
        this.storeCredential = storeCredential;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        if (!ownerId.equals(this.ownerId)) {
            String oldValue = this.ownerId;
            this.ownerId = ownerId;
            this.firePropertyChange(PROPERTY_OWNER_ID, oldValue, ownerId);
        }
    }

    public String getProviderName() {
        return JClouds.text(this.getProvider());
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getApiName() {
        if (this.getApi() != null) {
            return JClouds.text(this.getApi());
        }
        if (this.getProvider() != null) {
            return JClouds.text(this.getProvider().getApiMetadata());
        }
        return null;
    }

    public String getApiId() {
        if (this.apiId != null) {
            return this.apiId;
        }
        if (this.getProvider() != null) {
            return this.getProvider().getApiMetadata().getId();
        }
        return null;
    }

    public static ComputeService createComputeService(CloudDetails details) {
        ProviderMetadata selectedProvider = details.getProvider();
        ApiMetadata selectedApi = details.getApi();
        if (selectedProvider == JClouds.EMPTY_PROVIDER && selectedApi == JClouds.EMPTY_API) {
            return null;
        }
        String identity = details.getIdentity();
        String credential = details.getCredential();
        String endpoint = details.getEndpoint();
        if (selectedProvider != null && !Strings.isBlank((String)identity) && !Strings.isBlank((String)credential)) {
            String providerId = selectedProvider.getId();
            String owner = details.getOwnerId();
            Properties props = new Properties();
            props.put("provider", providerId);
            props.put(PROPERTY_IDENTITY, identity);
            props.put(PROPERTY_CREDENTIAL, credential);
            if (!Strings.isBlank((String)owner)) {
                props.put("jclouds.ec2.ami-query", "owner-id=" + owner + ";state=available;image-type=machine;root-device-type=ebs");
            } else {
                props.put("jclouds.ec2.ami-query", "state=available;image-type=machine;root-device-type=ebs");
            }
            long scriptTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES);
            props.setProperty("jclouds.compute.timeout.script-complete", String.valueOf(scriptTimeout));
            ContextBuilder builder = null;
            if (selectedProvider != null && selectedProvider != JClouds.EMPTY_PROVIDER) {
                builder = ContextBuilder.newBuilder((ProviderMetadata)selectedProvider);
            } else if (selectedApi != null && selectedApi != JClouds.EMPTY_API) {
                builder = ContextBuilder.newBuilder((ApiMetadata)selectedApi);
            }
            if (endpoint != null && !endpoint.isEmpty()) {
                builder = builder.endpoint(endpoint);
            }
            builder = builder.credentials(identity, credential);
            builder = builder.overrides(props);
            builder = builder.modules((Iterable)ImmutableSet.of((Object)new ManagementLifecycle((ManagementContext)BaseManagementContext.INSTANCE)));
            builder = builder.name(providerId).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule()));
            ComputeServiceContext context = (ComputeServiceContext)builder.build(ComputeServiceContext.class);
            return context.getComputeService();
        }
        return null;
    }
}

