/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.jboss.tools.jmx.core.tree.Node;

public class ProfileDeleteAction
extends Action {
    private final ProfileNode node;

    public ProfileDeleteAction(ProfileNode node) {
        super(Messages.profileDeleteLabel);
        this.node = node;
        this.setToolTipText(Messages.profileDeleteTooltip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("delete.gif"));
    }

    public void run() {
        ProfileDTO profile = this.node.getProfile();
        String message = Messages.bind((String)Messages.deleteProfileMessage, (Object)profile.getId());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.deleteProfileDialogTitle, (String)message);
        if (confirm) {
            this.node.getFabric().getFabricService().deleteProfile(this.node.getVersionNode().getVersionId(), profile.getId());
            Node parent = this.node.getParent();
            if (parent != null) {
                parent.removeChild((Node)this.node);
                ((FabricNodeSupport)parent).refresh();
            }
        }
    }
}

