/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.fabric8.ui.FabricConnector;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;

public class FabricConnectAction
extends Action {
    private Fabric fabric;

    public FabricConnectAction(Fabric fabric) {
        super(Messages.fabricConnectButton);
        this.setToolTipText(Messages.fabricConnectButtonTooltip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("connect.gif"));
        this.fabric = fabric;
    }

    public boolean isEnabled() {
        return this.fabric != null && !this.fabric.isConnected();
    }

    public void run() {
        if (this.fabric == null) {
            return;
        }
        Jobs.schedule((String)("Connecting to Fabric at " + this.fabric.getDetails().getUrls() + " ..."), (Runnable)new Runnable(){

            @Override
            public void run() {
                FabricConnectAction.this.fabric.setConnector(new FabricConnector(FabricConnectAction.this.fabric));
                try {
                    try {
                        FabricConnectAction.this.fabric.getConnector().connect();
                    }
                    catch (IOException iOException) {
                        FabricConnectAction.this.fabric.refresh();
                    }
                }
                finally {
                    FabricConnectAction.this.fabric.refresh();
                }
            }
        });
    }
}

