/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.properties.PropertySheet;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.fabric8.core.dto.ProfileStatusDTO;
import org.fusesource.ide.fabric8.core.dto.RequirementsDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.properties.FabricTabViewPage;

public class DeleteProfileRequirementAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection isel = (IStructuredSelection)sel;
            for (Object o : isel.toList()) {
                if (!(o instanceof ProfileStatusDTO)) continue;
                this.deleteRequirementsForProfile(event, ((ProfileStatusDTO)o).getProfile());
            }
        }
        return null;
    }

    private void deleteRequirementsForProfile(ExecutionEvent event, String profileId) {
        Fabric fabricNode = this.getSelectedFabric();
        RequirementsDTO reqs = fabricNode.getFabricService().getRequirements();
        try {
            if (reqs.findProfileRequirements(profileId) != null) {
                reqs.removeProfileRequirements(profileId);
                return;
            }
        }
        finally {
            try {
                fabricNode.getFabricService().setRequirements(reqs);
            }
            finally {
                PropertySheet ps;
                IWorkbenchPart wp = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (wp instanceof PropertySheet && (ps = (PropertySheet)wp).getCurrentPage() instanceof FabricTabViewPage) {
                    FabricTabViewPage ftvp = (FabricTabViewPage)ps.getCurrentPage();
                    ftvp.refresh();
                }
            }
        }
    }

    private Fabric getSelectedFabric() {
        Fabric f = null;
        Object selectedFabricObject = Selections.getFirstSelection((ISelection)FabricPlugin.getFabricNavigator().getCommonViewer().getSelection());
        if (selectedFabricObject != null && selectedFabricObject instanceof Fabric) {
            f = (Fabric)selectedFabricObject;
        }
        return f;
    }
}

